#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"

torus::torus()
{
	Name = "torus";

	Manager.load_map("data/torus.ase");
	Torus = Manager.Maps.back();
}

torus::~torus()
{
}

void torus::on_enter(void* Parameter)
{
	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
}

void torus::on_leave()
{
}

void torus::display_func()
{
	glClear(GL_COLOR_BUFFER_BIT);

	float Time = sys_timer();

	glEnable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, 4.0 / 3.0, 10, 10000);

	bil::vector Pos = bil::vector(cos(Time * 1.5), sin(Time * 0.9) * 0.05, sin(Time * 1.5));
	Pos.normalize();
	Pos *= 100;
	Pos.x += 100;
	bil::vector Tar = bil::vector(cos((Time + 1) * 1.5), sin((Time + 1) * 0.9) * 0.05, sin((Time + 1) * 1.5));
	Tar *= 100;
	Tar.x += 100;

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(
		Pos.x, Pos.y, Pos.z,
		Tar.x, Tar.y, Tar.z,
		sin(sin(Time * 0.2) * 0.3), cos(sin(Time * 0.2) * 0.3), 0);
	
	for(size_t VertexIndex = 0; VertexIndex < Torus->VertexCount; VertexIndex++)
	{
		vertex& Vertex =  Torus->Vertices[VertexIndex];
	
		bil::vector Normal = bil::vector(Vertex.x, Vertex.y, Vertex.z).normalize();

		Vertex.u = sin(Normal.x * 3 * sin(Time * 0.29) + Normal.y * 3 * cos(Time * 0.45) + Normal.z * 3 * sin(Time * 0.19));
		Vertex.v = sin(Normal.x * 3 * sin(Time * 0.42) + Normal.y * 3 * cos(Time * 0.33) + Normal.z * 3 * cos(Time * 0.35));
	}

	glColor4f(0, 0.25, 0.5, 0.45);
	Torus->render();

	START_END(56.625, 57.625)
	{
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glDisable(GL_TEXTURE_2D);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);

		glColor4f(1, 1, 1, 1 - (Time - TIME(56.625)) / TIME(1));
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}

	if(Time >= TIME(64.625))
		leave();
}

