#include <math.h>
#include <iostream.h>
#include <GL/glut.h>
#include "states.h"
#include "3dengine.h"

static struct
{
	bil::vector Pos;
	float r, g, b;
} Stars[2000];

space::space()
{
	Name = "space trip";

	Manager.load_map("data/box.ase");
	Box = Manager.Maps.back();
	Vertices = new vertex[Box->VertexCount];
	memcpy(Vertices, Box->Vertices, Box->VertexCount * sizeof(vertex));

	Manager.load_image("data/star.png");
	Star = Manager.Images.back();

	for(size_t StarIndex = 0; StarIndex < sizeof(Stars) / sizeof(Stars[0]); StarIndex++)
	{
		Stars[StarIndex].Pos =
			bil::vector(
				((float) rand() / RAND_MAX) - 0.5,
				((float) rand() / RAND_MAX) - 0.5,
				((float) rand() / RAND_MAX) - 0.5) * 10000;
		Stars[StarIndex].r = 0.8 + sin((float) rand() / RAND_MAX * 3.14) * 0.2;
		Stars[StarIndex].g = 0.8 + sin((float) rand() / RAND_MAX * 3.14) * 0.2;
		Stars[StarIndex].b = 0.8 + sin((float) rand() / RAND_MAX * 3.14) * 0.2;
	}
}

space::~space()
{
}

void space::on_enter(void* Parameter)
{
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
	glEnable(GL_BLEND);
}

void space::on_leave()
{
}

void space::display_func()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glEnable(GL_TEXTURE_2D);

	float Time = sys_timer();

	if(Time > TIME(32))
		leave();

	matrix Camera;

	Camera.rotate(bil::vector(sin(Time * 1), cos(Time * 1.1), sin(Time * 0.9)), Time);
	
	Camera *= matrix().translate(sin(Time * 0.13 + sin(Time * 0.3) * 3) * 1000, cos(Time * 0.23 + sin(Time * 0.4) * 3) * 1000, sin(Time * 0.19) * 1000);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	image::set(0, Star);

	for(size_t StarIndex = 0; StarIndex < sizeof(Stars) / sizeof(Stars[0]); StarIndex++)
	{
		bil::vector Pos = Stars[StarIndex].Pos * Camera;
		
		if(Pos.z <= 0)
			continue;

		glColor4f(Stars[StarIndex].r, Stars[StarIndex].g, Stars[StarIndex].b, 1);

		float Scale = 0.03 / (1 + Pos.z * 0.0005);
		Star->draw(Pos.x / Pos.z - Scale, Pos.y / Pos.z - Scale, Pos.x / Pos.z + Scale, Pos.y / Pos.z + Scale);
	}

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, 4.0 / 3.0, 10, 10000);

	bil::vector Pos = bil::vector(cos(Time) + 0.1, sin(Time * 1.1), sin(Time * 0.9));

	Pos.normalize();
	Pos *= 250;
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(Pos.x, Pos.y, Pos.z,
		0, 0, 0,
		0, 1, 0);

	//glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glColor4f(0.25, 0.5, 1, 0.5);

	START_END(24, 32)
	{
		for(size_t VertexIndex = 0; VertexIndex < Box->VertexCount; VertexIndex++)
		{
			float Angle = 0.3 * cos(Vertices[VertexIndex].x / 100 + Time * 5);
			
			float x, y, z;
			x	= Vertices[VertexIndex].x * cos(Angle)
				+ Vertices[VertexIndex].y * sin(Angle);
			y	= Vertices[VertexIndex].y * cos(Angle)
				- Vertices[VertexIndex].x * sin(Angle);
			z = Vertices[VertexIndex].z;
	
			Angle = 0.3 * cos(Vertices[VertexIndex].y / 100 + Time * 7);
	
			Box->Vertices[VertexIndex].x = x;
			Box->Vertices[VertexIndex].y
				= cos(Angle) * y//Vertices[VertexIndex].y
				+ sin(Angle) * z;//Vertices[VertexIndex].z;
			Box->Vertices[VertexIndex].z
				= cos(Angle) * z//Vertices[VertexIndex].z
				- sin(Angle) * y;//Vertices[VertexIndex].y;
		}
	}

	Box->render();
	
	glMatrixMode(GL_MODELVIEW);
	glScaled(1.1, 1.1, 1.1);
	
	glColor4f(1, 0.25, 0.5, 0.25);
	
	Box->render();
	
	START_END(16, 17)
	{
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glDisable(GL_TEXTURE_2D);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);

		glColor4f(1, 1, 1, 1 - (Time - TIME(16)) / TIME(1));
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}
	START_END(24, 25)
	{
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glDisable(GL_TEXTURE_2D);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);

		glColor4f(1, 1, 1, 1 - (Time - TIME(24)) / TIME(1));
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}
}

