#ifndef _SCENE_H_
#define _SCENE_H_

#include <vector>

#include "texture.h"
#include "model.h"

extern texture_manager TextureManager;

class scene
{
public:
	scene();
	~scene();

	string         Name;

	float               FirstFrame;
	float               LastFrame;
	float               FrameRate;

	color               Background;
	color               Ambient;

	std::vector<model*> Models;

	size_t              MaterialCount;
	size_t*	            Materials;
};

scene* ase_load(const char* FileName);
scene* bsp_load(const char* FileName);

void   bsp_write(const char* FileName, scene* Scene);

#endif

