#include <iostream.h>
#include <stdio.h>
#include <png.h>
#include "import.h"

const size_t PNG_HEADER_SIZE = 8;

i_image* png_load(const char* FileName)
{
	cerr << "INFO: png_load: Loading '" << FileName << "'..." << endl;

	FILE* File = fopen(FileName, "rb");

	if(!File)
	{
		cerr << "ERROR: png_load: Failed to open input file." << endl;
		return NULL;
	}

	unsigned char Header[PNG_HEADER_SIZE];

	fread(Header, 1, PNG_HEADER_SIZE, File);

	if(png_sig_cmp(Header, 0, PNG_HEADER_SIZE))
	{
		cerr << "ERROR: png_load: Not a Portable Network Graphics file." << endl;
		fclose(File);
		return NULL;
	}

	png_structp PngPointer = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);

	if(!PngPointer)
	{
		cerr << "ERROR: png_load: Insufficient memory." << endl;
		fclose(File);

		return NULL;
	}

	png_infop PngInfo = png_create_info_struct(PngPointer);

	if(!PngInfo)
	{
		png_destroy_read_struct(&PngPointer, (png_infopp) NULL, (png_infopp) NULL);
		fclose(File);

		return NULL;
	}

	png_infop PngEndInfo = png_create_info_struct(PngPointer);

	if(!PngEndInfo)
	{
		png_destroy_read_struct(&PngPointer, (png_infopp) NULL, (png_infopp) NULL);
		fclose(File);

		return NULL;
	}

	if(setjmp(png_jmpbuf(PngPointer)))
	{
		png_destroy_read_struct(&PngPointer, (png_infopp) NULL, (png_infopp) NULL);
		fclose(File);

		return NULL;
	}

	png_init_io(PngPointer, File);

	png_set_sig_bytes(PngPointer, PNG_HEADER_SIZE);

	png_read_png(PngPointer, PngInfo, 0*PNG_TRANSFORM_BGR, NULL);

	i_image* Image = new i_image;

	Image->Data = new char[PngInfo->height * PngInfo->rowbytes];
	Image->Width = PngInfo->width;
	Image->Height = PngInfo->height;

	if(PngInfo->bit_depth != 8 || PngInfo->color_type != PNG_COLOR_TYPE_RGB)
	{
		if(PngInfo->bit_depth != 8)
			cerr << "ERROR: png_load: Bit depth is " << PngInfo->bit_depth << ", needs to be 8." << endl;
		else
			cerr << "ERROR: png_load: Invalid color packing format, needs to be RGB." << endl;

		png_destroy_read_struct(&PngPointer, (png_infopp) NULL, (png_infopp) NULL);
		fclose(File);
		return NULL;
	}

	for(size_t RowIndex = 0; RowIndex < PngInfo->height; RowIndex++)
		memcpy(&Image->Data[RowIndex * PngInfo->rowbytes], PngInfo->row_pointers[RowIndex], PngInfo->rowbytes);

	png_destroy_read_struct(&PngPointer, &PngInfo, &PngEndInfo);

	fclose(File);

	return Image;
}

