#include <iostream.h>
#include <algorithm>
#include "3dengine.h"

void map::render()
{
	size_t FaceIndex;

	for(FaceIndex = 0; FaceIndex < FaceCount; FaceIndex++)
		Faces[FaceIndex].set();
}

void map::optimize()
{
	size_t FaceIndex;

	for(FaceIndex = 0; FaceIndex < FaceCount; FaceIndex++)
	{
		size_t FaceIndex2;

		for(FaceIndex2 = FaceIndex + 1; FaceIndex2 < FaceCount; FaceIndex2++)
		{
			// XXX: Disfunctional, doesn't check whether polygon becomes concave

			if(Faces[FaceIndex].VertexCount > 3)
				break;

			if(Faces[FaceIndex2].VertexCount > 3)
				break;

			if((Faces[FaceIndex2].Colormap != Faces[FaceIndex].Colormap)
			|| (Faces[FaceIndex2].Lightmap != Faces[FaceIndex].Lightmap))
				continue;

			size_t VertexIndex;

			for(VertexIndex = 0; VertexIndex < Faces[FaceIndex].VertexCount; VertexIndex++)
			{
				vertex* p1 = Faces[FaceIndex].Vertices[VertexIndex];
				vertex* p2 = (VertexIndex + 1 < Faces[FaceIndex].VertexCount)
                           ? Faces[FaceIndex].Vertices[VertexIndex + 1]
				           : Faces[FaceIndex].Vertices[0];

				size_t VertexIndex2;

				for(VertexIndex2 = 0; VertexIndex2 < Faces[FaceIndex2].VertexCount; VertexIndex2++)
				{
					vertex* q1 = Faces[FaceIndex2].Vertices[VertexIndex2];
					vertex* q2 = (VertexIndex2 + 1 < Faces[FaceIndex2].VertexCount)
					           ? Faces[FaceIndex2].Vertices[VertexIndex2 + 1]
					           : Faces[FaceIndex2].Vertices[0];

					if(q1 == p1 && q2 == p2)
					{
						size_t NewCount = Faces[FaceIndex2].VertexCount - 2;
						Faces[FaceIndex].VertexCount += NewCount;

						vertex** Old = Faces[FaceIndex].Vertices;
						Faces[FaceIndex].Vertices = new vertex*[Faces[FaceIndex].VertexCount];
						size_t n, o;
						for(n = 0; n <= VertexIndex; n++)
							Faces[FaceIndex].Vertices[n] = Old[n];
						for(n = 0, o = VertexIndex2 + 2; n < NewCount; n++, o++)
						{
							o %= Faces[FaceIndex2].VertexCount;
		
							Faces[FaceIndex].Vertices[VertexIndex + 1 + n] = Faces[FaceIndex2].Vertices[o];
						}
						for(n = VertexIndex + NewCount + 1; n < Faces[FaceIndex].VertexCount; n++)
							Faces[FaceIndex].Vertices[n] = Old[n - NewCount];
						
						delete [] Old;

						Faces[FaceIndex2].VertexCount = 0;
						delete [] Faces[FaceIndex2].Vertices;
					}
					else if(q1 == p2 && q2 == p1)
					{
						size_t NewCount = Faces[FaceIndex2].VertexCount - 2;
						Faces[FaceIndex].VertexCount += NewCount;

						vertex** Old = Faces[FaceIndex].Vertices;
						Faces[FaceIndex].Vertices = new vertex*[Faces[FaceIndex].VertexCount];
						size_t n, o;
						for(n = 0; n <= VertexIndex; n++)
							Faces[FaceIndex].Vertices[n] = Old[n];
						for(n = 0, o = VertexIndex2 - 1; n < NewCount; n++, o--)
						{
							if(o == (size_t) -1)
								o = Faces[FaceIndex2].VertexCount - 1;
		
							Faces[FaceIndex].Vertices[VertexIndex + 1 + n] = Faces[FaceIndex2].Vertices[o];
						}
						for(n = VertexIndex + NewCount + 1; n < Faces[FaceIndex].VertexCount; n++)
							Faces[FaceIndex].Vertices[n] = Old[n - NewCount];
						
						delete [] Old;

						Faces[FaceIndex2].VertexCount = 0;
						delete [] Faces[FaceIndex2].Vertices;
					}
				}
			}
		}		
	}

	size_t NewCount = 0;

	for(FaceIndex = 0; FaceIndex < FaceCount; FaceIndex++)
		if(Faces[FaceIndex].VertexCount)
			NewCount++;

	if(NewCount == FaceCount)
		return;

	polygon* Old = Faces;

	Faces = new polygon[NewCount];

	size_t NewIndex = 0;

	for(FaceIndex = 0; FaceIndex < FaceCount; FaceIndex++)
	{
		if(Old[FaceIndex].VertexCount)
			Faces[NewIndex++] = Old[FaceIndex];
	}

	delete [] Old;

	cerr << "INFO: map::optimize: " << (FaceCount - NewCount) << " faces removed by bundling adjecent faces." << endl;

	FaceCount = NewCount;
}
