#include <iostream.h>

#include <GL/gl.h>
#include <GL/glut.h>

#include "config.h"
#include "system.h"
#include "states.h"
#include "audio.h"

void glut_init();

int main(int argc, char** argv)
{
	config_read("data/config.scr");

	glut_init();
	sys_init();

	state::init();

	demo* Demo = new demo;
	
	state::enter(Demo, NULL);

	sys_timer();
	
	glutMainLoop();

	return(0);
}

void glut_init()
{
	cerr << "INFO: glut_init: Opening a " << ScreenWidth << "x" << ScreenHeight << " window..." << endl;

	glutInitDisplayMode(GLUT_RGBA | GLUT_DEPTH | GLUT_DOUBLE);
	glutInitWindowPosition(0, 0);
	glutInitWindowSize(ScreenWidth, ScreenHeight);

	glutCreateWindow(ApplicationName);

	if(FullScreen)
	{
		glutFullScreen();
		glutSetCursor(GLUT_CURSOR_NONE);
	}

	if(glGetString(GL_VENDOR))
		cerr << glGetString(GL_VENDOR) << ", " << glGetString(GL_RENDERER) << endl;
}
