#include <iostream.h>
#include <GL/gl.h>
#include <GL/glut.h>
#ifndef WIN32
#include <dlfcn.h>
#endif
#include "glext.h"

GLMULTITEXCOORD2F glMultiTexCoord2f = NULL;
GLACTIVETEXTURE glActiveTexture = NULL;
GLint glMaxTextureUnits = 1;

void glext_init()
{
	cerr << "INFO: glext_init: Binding extension functions..." << endl;

	if(glutExtensionSupported("GL_ARB_multitexture"))
	{
#ifdef WIN32
		glActiveTexture = (GLACTIVETEXTURE) wglGetProcAddress("glActiveTextureARB");
		glMultiTexCoord2f = (GLMULTITEXCOORD2F) wglGetProcAddress("glMultiTexCoord2fARB");
#else
		void* LibHandle = dlopen(NULL, RTLD_LAZY);

		glActiveTexture = (GLACTIVETEXTURE) dlsym(LibHandle, "glActiveTextureARB");
		glMultiTexCoord2f = (GLMULTITEXCOORD2F) dlsym(LibHandle, "glMultiTexCoord2fARB");
#endif
		if(!glActiveTexture)
			cerr << "WARNING: glActiveTextureARB unavailable." << endl;

		glGetIntegerv(GL_MAX_TEXTURE_UNITS, &glMaxTextureUnits);
	}
	else
	{
		// XXX: Bind to fake functions
	}

	cerr << "INFO: glext_init: " << glMaxTextureUnits << " texture mapping units." << endl;
}

