#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"
#include "audio.h"

demo::demo()
{
	Name = "demo";

	glext_init();

	Song = new audio::stream("data/music.mp3");
	Intro = new intro;
	CarStart = new car_start;
	Space = new space;
	Ball = new ball;
	Credits = new credits;
	Torus = new torus;
	Tunnel = new tunnel;
	Flare = new flare;
	Chain = new chain;
	All = new all;
	Outro = new outro;
}

demo::~demo()
{
	delete Outro;
	delete All;
	delete Chain;	
	delete Flare;
	delete Tunnel;
	delete Torus;
	delete Credits;
	delete Ball;
	delete Space;
	delete CarStart;
	delete Intro;
	delete Song;
}

void demo::on_enter(void* Parameter)
{
	Song->play();
	sys_timer();
}

void demo::on_leave()
{
}

void demo::display_func()
{
	float Time = sys_timer();

	END(8)
	{
		state::enter(Intro, NULL);
	}
	else END(16)
	{
		state::enter(CarStart, NULL);
	}
	else END(32)
	{
		state::enter(Space, NULL);
	}
	else END(48)
	{
		state::enter(Ball, NULL);
	}
	else END(56.625)
	{
		state::enter(Credits, NULL);
	}
	else END(64.625)
	{
		state::enter(Torus, NULL);
	}
	else END(72.625)
	{
		state::enter(Tunnel, NULL);
	}
	else END(73)
	{
		glClear(GL_COLOR_BUFFER_BIT);
	}
	else END(81)
	{
		state::enter(Flare, NULL);
	}
	else END(89)
	{
		state::enter(Chain, NULL);
	}
	else END(97)
	{
		state::enter(All, NULL);
	}
	else END(107)
	{
		state::enter(Outro, NULL);
	}
	else
		leave();
}

