#include <stdio.h>
#include <iostream.h>
#include <fstream>
#include <string>

#ifdef WIN32
using std::ifstream;
#endif

int  ScreenWidth = 640;
int  ScreenHeight = 480;
int  FullScreen = 1;
char ApplicationName[256] = "Tsunami";

enum data_type { integer, str };

static const struct
{
	void*     Variable;
	data_type DataType;
	char*     Name;
} Variables[] = {
	{ &ScreenWidth,     integer, "ScreenWidth" },
	{ &ScreenHeight,    integer, "ScreenHeight" },
	{ &FullScreen,      integer, "FullScreen" },
	{ &ApplicationName, str,  "ApplicationName" },
};

void config_read(const char* FileName)
{
	cerr << "INFO: config_read: Loading '" << FileName << "'..." << endl;

	ifstream ConfigFile(FileName);
	string   Line;
	size_t        LineNumber = 0;

	while(std::getline(ConfigFile, Line))
	{
		LineNumber++;

		for(size_t i = 0; i < sizeof(Variables) / sizeof(Variables[0]); i++)
		{
			if(Line.find(Variables[i].Name) == 0)
			{
				switch(Variables[i].DataType)
				{
				case integer:
					if(1 != sscanf(Line.c_str(), "%*s = %i", (int*) Variables[i].Variable))
					{
						cerr << "ERROR: config_read: line " << LineNumber << ": parse error" << endl;
						exit(1);
					}
					break;
				case str:
					if(Line.length() > 256 + strlen(Variables[i].Name))
					{
						cerr << "ERROR: config_read: line " << LineNumber << ": line too long" << endl;
						exit(1);
					}
					if(1 != sscanf(Line.c_str(), "%*s = %s", (char*) Variables[i].Variable))
					{
						cerr << "ERROR: config_read: line " << LineNumber << ": parse error" << endl;
						exit(1);
					}
					break;
				}
				break;
			}
		}
	}
}

