#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"

chain::chain()
{
	Name = "chain";

	Manager.load_map("data/chain.ase");
	Chain = Manager.Maps.back();
	Manager.load_map("data/ball.ase");
	Ball = Manager.Maps.back();
}

chain::~chain()
{
}

void chain::on_enter(void* Parameter)
{
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glDisable(GL_CULL_FACE);
	glEnable(GL_DEPTH_TEST);
}

void chain::on_leave()
{
}

void chain::display_func()
{
	float Time = sys_timer() - TIME(81);

	if(Time >= TIME(8))
		leave();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, 4.0 / 3.0, 10, 10000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(sin(Time * 3) * 100, cos(Time * 3) * 100, -720 + Time / TIME(8) * 1000, 0, 0, -700 + Time / TIME(8) * 1000, 0, 1, 0);


	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
	glColor3f(1, 0.25, 0.5);
	Chain->render();

	glRotatef(90, 0, 0, 1);
	glColor3f(0.5, 0.25, 1);
	Chain->render();

	for(size_t VertexIndex = 0; VertexIndex < Ball->VertexCount; VertexIndex++)
	{
		vertex& Vertex = Ball->Vertices[VertexIndex];

		bil::vector Normal = bil::vector(Vertex.x, Vertex.y, Vertex.z).normalize();

	Vertex.u = sin(Normal.x * 3 * sin(Time * 0.7) + Normal.y * 2 * cos(Time * 0.5) + Normal.z * 3 * sin(Time * 0.3));	
	Vertex.v = sin(Normal.x * 3 * sin(Time * 0.6) + Normal.y * 2 * cos(Time * 0.3) + Normal.z * 3 * sin(Time * 0.4));
	}
	glColor3f(0.1, 0.05, 0.1);
	glScalef(20, 20, 20);
	Ball->render();

	END(1)
	{
		glColor4f(1, 1, 1, 1 - Time / TIME(1));
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}
}

