#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"

car_start::car_start()
{
	Name = "car start";

	Manager.load_map("data/plate.ase");
	City = Manager.Maps.back();
	Manager.load_map("data/car.ase");
	Car = Manager.Maps.back();
	Manager.load_image("data/env.png");
	Environ = Manager.Images.back();

	for(size_t i = 0; i < Car->VertexCount; i++)
		Car->Vertices[i].y += 11.8863;
	for(size_t i = 0; i < City->VertexCount; i++)
		City->Vertices[i].y += 11.8863;
}

car_start::~car_start()
{
}

void car_start::on_enter(void* Parameter)
{
	glCullFace(GL_FRONT);
	//glActiveTexture(GL_TEXTURE0);
	//glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_SET);
//	glActiveTexture(GL_TEXTURE1);
//	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
}

void car_start::on_leave()
{
}

void car_start::display_func()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glDisable(GL_BLEND);

	float Time = sys_timer();

	glEnable(GL_TEXTURE_2D);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, 4.0 / 3.0, 10, 10000);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	bil::vector Camera;
	
	END(10)
	{
		Camera = bil::vector(100 - ((Time - TIME(8)) / TIME(1)) * 50, 50, 100 - ((Time - TIME(8)) / TIME(1)) * 100);
	}
	else END(12)
	{
		Camera = bil::vector(100 - ((Time - TIME(10)) / TIME(1)) * 100, 50, 100);
	}
	else END(14)
	{
		Camera = bil::vector(50, 100 - ((Time - TIME(12)) / TIME(1)) * 50, 0);
	}
	else END(16)
	{
		Camera = bil::vector(-100 + ((Time - TIME(14)) / TIME(1)) * 100, 50, -100);
	}
	else
	{
		leave();
		return;
	}

	gluLookAt(Camera.x, Camera.y + 12, Camera.z, 0, 0, 0, 0, 1, 0);
	Camera.normalize();

	glEnable(GL_CULL_FACE);
	glEnable(GL_DEPTH_TEST);

	//City->render();

//	bil::vector Light = bil::vector(-1, -2, -3).normalize();

	glScalef(1, -1, 1);
	glCullFace(GL_BACK);
	Car->render();
	
	glScalef(1, -1, 1);
	glCullFace(GL_FRONT);

	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);	
	City->render();
	glDisable(GL_BLEND);
	Car->render();

/*	
	cerr << "a" << endl; cerr.flush();
	glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_2D, Environ->TextureIndex);
	cerr << "b" << endl; cerr.flush(); */
	//image::set(1, Environ);

	/*
	glColor3f(1, 1, 1);
	for(size_t FaceIndex = 0; FaceIndex < Car->FaceCount; FaceIndex++)
	{
		polygon& Face = Car->Faces[FaceIndex];

		image::set(0, Face.Colormap);

		glBegin(GL_POLYGON);
		for(size_t i = 0; i < Face.VertexCount; i++)
		{
//			bil::vector Env = Face.Vertices[i]->Normal.cross(Camera);

			glMultiTexCoord2f(GL_TEXTURE0, Face.Vertices[i]->u, Face.Vertices[i]->v);
//			glMultiTexCoord2f(GL_TEXTURE1, Env.x * 0.5 + 0.5, Env.y * 0.5 + 0.5);
			glVertex3f(Face.Vertices[i]->x, Face.Vertices[i]->y, Face.Vertices[i]->z);
		}
		glEnd();
	}
	*/
	/*
	cerr << "c" << endl; cerr.flush();
	glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_2D, 0);
	cerr << "d" << endl; cerr.flush();
	*/
	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);

	image::set(0, NULL);
	//image::set(1, NULL);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);

	END(9)
	{
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);	
	
		glColor4f(1, 1, 1, 1 - (Time - TIME(8)) / TIME(1));
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}
}

