#include <math.h>
#include <iostream.h>
#include "states.h"
#include "3dengine.h"

ball::ball()
{
	Name = "ball";

	Manager.load_map("data/ball.ase");
	Ball = Manager.Maps.back();
	Vertices = new vertex[Ball->VertexCount];
	memcpy(Vertices, Ball->Vertices, Ball->VertexCount * sizeof(vertex));
}

ball::~ball()
{
	delete [] Vertices;
}

void ball::on_enter(void* Parameter)
{
	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
}

void ball::on_leave()
{
}

void ball::display_func()
{
	glClear(GL_COLOR_BUFFER_BIT);

	float Time = sys_timer();

	glEnable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90, 4.0 / 3.0, 10, 10000);

	bil::vector Pos = bil::vector(cos(Time * 1.5), sin(Time * 0.9), sin(Time * 1.3));
	Pos.normalize();
	Pos *= 170;
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(
		Pos.x, Pos.y, Pos.z,
		cos(Time) * -5, cos(Time * 1.3) * 5, sin(Time) * -5,
		0, 1, 0);
	
	for(size_t VertexIndex = 0; VertexIndex < Ball->VertexCount; VertexIndex++)
	{
		vertex& Vertex =  Ball->Vertices[VertexIndex];
	
		bil::vector Normal = bil::vector(Vertex.x, Vertex.y, Vertex.z).normalize();

		Vertex.u = sin(Normal.x * 3 * sin(Time * 0.29) + Normal.y * 3 * cos(Time * 0.45) + Normal.z * 3 * sin(Time * 0.19));
		Vertex.v = sin(Normal.x * 3 * sin(Time * 0.42) + Normal.y * 3 * cos(Time * 0.33) + Normal.z * 3 * cos(Time * 0.35));

		START_END(40, 48)
		{
			Vertex.x = Vertices[VertexIndex].x * 
			(1 + 0.5 * sin(Normal.x * 2 * sin(Time / 0.49) + Normal.y * 2 * cos(Time / 0.35) + Normal.z * 2 * sin(Time / 0.19)));
			Vertex.y = Vertices[VertexIndex].y * 
			(1 + 0.5 * sin(Normal.x * 2 * sin(Time / 0.29) + Normal.y * 2 * cos(Time / 0.45) + Normal.z * 2 * sin(Time / 0.22)));
			Vertex.z = Vertices[VertexIndex].z; 
		}
	}

	glColor4f(0, 0.25, 0.5, 0.45);
	Ball->render();

	glScaled(1.2, 1.2, 1.2);
	glColor4f(0.5, 0.25, 1, 0.35);
	Ball->render();
	
	glScaled(1.2, 1.2, 1.2);
	glColor4f(0, 0.5, 1, 0.25);
	Ball->render();
	
	glScaled(1.2, 1.2, 1.2);
	glColor4f(0.25, 1, 1, 0.25);
	Ball->render();

	glScaled(8, 8, 8);
	glColor4f(0.5, 0.25, 1, 0.5);
	Ball->render();

    START_END(32, 33)
    {
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glDisable(GL_TEXTURE_2D);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);

		glColor4f(1, 1, 1, 1 - (Time - TIME(32)) / TIME(1));
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}

    START_END(40, 41)
    {
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glDisable(GL_TEXTURE_2D);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);

		glColor4f(1, 1, 1, 1 - (Time - TIME(40)) / TIME(1));
		glBegin(GL_QUADS);
		glVertex3f(-1, -1, 0.5f);
		glVertex3f( 1, -1, 0.5f);
		glVertex3f( 1,  1, 0.5f);
		glVertex3f(-1,  1, 0.5f);
		glEnd();
	}		

	if(Time >= TIME(48))
		leave();
}

