#ifndef _3DENGINE_H_
#define _3DENGINE_H_

#include <stdlib.h>
#include <vector>
#include <iostream.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "matrix.h"
#include "vector.h"
#include "import.h"
#include "glext.h"
#include "system.h"

class color
{
public:
	unsigned char       r, g, b;

	inline void set()
	{
		glColor3b(r, g, b);
	}
};

class image
{
private:
	static GLuint       CurrentTexture[32];


public:
	GLuint              TextureIndex;      // Texture index common to OpenGL

	color*              Data;
	size_t              Width;
	size_t              Height;

	void                load(const char* FileName);
	void                load(i_image& ImportImage);

	static inline void set(size_t Pass, image* Image)
	{
		if(!Image)
		{
			glActiveTexture(GL_TEXTURE0 + Pass);
			glDisable(GL_TEXTURE_2D);
			glBindTexture(GL_TEXTURE_2D, CurrentTexture[Pass] = 0);

			return;
		}

		if(CurrentTexture[Pass] != Image->TextureIndex)
		{
			glActiveTexture(GL_TEXTURE0 + Pass);
			glBindTexture(GL_TEXTURE_2D, CurrentTexture[Pass] = Image->TextureIndex);
		}
	}

	inline void draw(float x1, float y1, float x2, float y2)
	{
		glBegin(GL_POLYGON);
		glTexCoord2f(0, 0);
		glVertex3f(x1, y1, 0.5f);
		glTexCoord2f(0.99f, 0);
		glVertex3f(x2, y1, 0.5f);
		glTexCoord2f(0.99f, 0.99f);
		glVertex3f(x2, y2, 0.5f);
		glTexCoord2f(0, 0.99f);
		glVertex3f(x1, y2, 0.5f);
		glEnd();
	}
};

class vertex
{
public:
	bil::vector         Normal;
	float               x, y, z;           // 3D coordinate
	float               u, v;              // Colormap coordinate
	float               s, t;              // Lightmap coordinate

	inline void set()
	{
/*
		glMultitexCoord2f(0, s, t);
		glMultitexCoord2f(1, u, v);
*/		glTexCoord2f(u, v);
		glVertex3f(x, y, z);
	}
};

class polygon
{
public:
	vertex**            Vertices;
	size_t              VertexCount;

	image*              Colormap;
	image*              Lightmap;

	bil::vector         Normal;
	float               Distance;

	inline void set()
	{
		if(Colormap)
			image::set(0, Colormap);

		if(Lightmap)
			image::set(1, Lightmap);

		glBegin(GL_POLYGON);
		for(size_t i = 0; i < VertexCount; i++)
			Vertices[i]->set();
		glEnd();
	}
};

class map_coord
{
public:
	float               u, v;
};

class map
{
private:
	size_t*             SortOrder;
public:
	vertex*             Vertices;
	size_t              VertexCount;

	polygon*            Faces;
	size_t              FaceCount;

	void                optimize();
	void                render();
};

class model
{
public:
	bil::vector*             Vertices;
	map_coord*          ColormapCoords;
	bil::vector*             VertexNormals;
	size_t              VertexCount;
	
	color*              LightLevels;

	size_t*             Indices;           // TriangleCount * 3
	size_t              TriangleCount;

	image*              Colormap;

	void                render();
};

class entity
{
public:
	model*              Model;
	matrix              Matrix;

	entity**            Children;
	size_t              ChildCount;

	void                render();
};

class light
{
public:
	bil::vector              Position;
	color               Color;
};

class camera
{
public:
	bil::vector              Eye, Target, Up;

	camera();
	~camera();

	inline void set()
	{
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		gluLookAt(
			Eye.x, Eye.y, Eye.z,
			Target.x, Target.y, Target.z,
			Up.x, Up.y, Up.z);
	}
};

class scene
{
public:
	map*                Map;

	light**             Lights;
	size_t              LightCount;

	entity**            Entities;
	size_t              EntityCount;

	camera              Camera;

	void                render();
};

class manager
{
public:
	std::vector<image*>  Images;
	std::vector<map*>    Maps;
	std::vector<model*>  Models;
	std::vector<entity*> Entities;
	std::vector<scene*>  Scenes;

	manager();
	~manager();

	void                 load_image(const char* FileName);
	void                 load_map(const char* FileName);
	void                 load_model(const char* FileName);
	void                 load_entity(const char* FileName);
	void                 load_scene(const char* FileName);
};

extern manager Manager;

#endif

