#include <iostream.h>
#include "3dengine.h"

manager Manager;

void manager::load_image(const char* FileName)
{
	image* Image = new image;

	Image->load(FileName);

	Images.push_back(Image);
}

void manager::load_map(const char* FileName)
{
	map* Map = new map;

	import* Import = ase_load(FileName);

	if(Import->Fields & IMPORT_MATERIALS)
	{
		std::vector<i_material>::iterator Material;

		for(Material = Import->Materials.begin(); Material != Import->Materials.end(); Material++)
		{
			if(Material->Colormap.length())
			{
				load_image(Material->Colormap.c_str());
				Material->Reserved = Images.back();	
			}
			else
			{
				cerr << "ERROR: manager::load_map: Texture missing for material." << endl;
			}
		}
	}

	if((Import->Fields & IMPORT_VERTICES) && (Import->Fields & IMPORT_FACES))
	{
		if(Import->Fields & IMPORT_COLORMAP_COORDS)
		{
			if(Import->Fields & IMPORT_TEXTURE_FACES)
			{
				Map->VertexCount = Import->ColormapCoords.size();
				Map->Vertices = new vertex[Map->VertexCount];

				size_t FaceIndex;

				for(FaceIndex = 0; FaceIndex < Import->Faces.size(); FaceIndex++)
				{
					for(size_t EdgeIndex = 0; EdgeIndex < Import->Faces[FaceIndex].IndexCount; EdgeIndex++)
					{
						size_t VertexIndex = Import->TextureFaces[FaceIndex].Indices[EdgeIndex];
						Map->Vertices[VertexIndex].x = Import->Vertices[Import->Faces[FaceIndex].Indices[EdgeIndex]].x;
						Map->Vertices[VertexIndex].y = Import->Vertices[Import->Faces[FaceIndex].Indices[EdgeIndex]].y;
						Map->Vertices[VertexIndex].z = Import->Vertices[Import->Faces[FaceIndex].Indices[EdgeIndex]].z;
						Map->Vertices[VertexIndex].u = Import->ColormapCoords[Import->TextureFaces[FaceIndex].Indices[EdgeIndex]].u;
						Map->Vertices[VertexIndex].v = Import->ColormapCoords[Import->TextureFaces[FaceIndex].Indices[EdgeIndex]].v;
					}
				}

				Map->FaceCount = Import->TextureFaces.size();
				Map->Faces = new polygon[Map->FaceCount];

				for(FaceIndex = 0; FaceIndex < Map->FaceCount; FaceIndex++)
				{
					polygon& Face = Map->Faces[FaceIndex];

					Face.VertexCount = Import->TextureFaces[FaceIndex].IndexCount;
					Face.Vertices = new vertex*[Face.VertexCount];

					for(size_t VertexIndex = 0; VertexIndex < Face.VertexCount; VertexIndex++)
					{
						Face.Vertices[VertexIndex] = &Map->Vertices[Import->TextureFaces[FaceIndex].Indices[VertexIndex]];
					}

					Face.Colormap = (image*) Import->Materials[Import->Faces[FaceIndex].MaterialIndex].Reserved;
					Face.Lightmap = NULL;
				}
			}
		}
	}

	for(size_t FaceIndex = 0; FaceIndex < Map->FaceCount; FaceIndex++)
	{
		polygon& Face = Map->Faces[FaceIndex];

		vertex* v1 = Face.Vertices[0];
		vertex* v2 = Face.Vertices[1];
		vertex* v3 = Face.Vertices[2];

		Face.Normal =
			(bil::vector(v2->x - v1->x, v2->y - v1->y, v2->z - v1->z).cross(
			bil::vector(v3->x - v1->x, v3->y - v1->y, v3->z - v1->z))).normalize();
	}
	
	for(size_t VertexIndex = 0; VertexIndex < Map->VertexCount; VertexIndex++)
	{
		bil::vector Normal;
		size_t Count = 0;
		vertex& Vertex = Map->Vertices[VertexIndex];

		for(size_t FaceIndex = 0; FaceIndex < Map->FaceCount; FaceIndex++)
		{
			for(size_t i = 0; i < Map->Faces[FaceIndex].VertexCount; i++)
			{
				if(Map->Faces[FaceIndex].Vertices[i] == &Vertex)
				{
					Normal += Map->Faces[FaceIndex].Normal;
					Count++;
				}
			}
		}

		if(Count == 0)
			cerr << "Vertex index " << VertexIndex << " er mystisk" << endl;

		Normal /= Count;

		Vertex.Normal = Normal;
	}

	Maps.push_back(Map);
}

void manager::load_model(const char* FileName)
{
}

void manager::load_entity(const char* FileName)
{
}

void manager::load_scene(const char* FileName)
{
}

manager::manager()
{
}

manager::~manager()
{
	std::vector<image*>::iterator Image;

	for(Image = Images.begin(); Image != Images.end(); Image++)
		delete *Image;

	std::vector<map*>::iterator Map;

	for(Map = Maps.begin(); Map != Maps.end(); Map++)
		delete *Map;

	std::vector<model*>::iterator Model;

	for(Model = Models.begin(); Model != Models.end(); Model++)
		delete *Model;

	std::vector<entity*>::iterator Entity;

	for(Entity = Entities.begin(); Entity != Entities.end(); Entity++)
		delete *Entity;

	std::vector<scene*>::iterator Scene;

	for(Scene = Scenes.begin(); Scene != Scenes.end(); Scene++)
		delete *Scene;
}
