#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "anarchy.h"
#include <GL/gl.h>
#include "scene.h"


static void worthless(Individual *i) {}

void map_fcalc(Map *d, Map *s1, Map *s2, float *k1, Map *s3, Map *s4, float *k2, int cnt1, int cnt2) {
  int i, j;
  static float one[]={1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};
  static float zero[]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
  int dd=0, s1d=0, s2d=0, s3d=0, s4d=0;
  char *dp=map_map(d, 0, cnt1, &dd), *dpb=dp;
  char *s1p=s1?map_map(s1, 0, cnt1, &s1d):one, *s1pb=s1p;
  char *s2p=s2?map_map(s2, 0, cnt1, &s2d):one, *s2pb=s2p;
  char *s3p=s3?map_map(s3, 0, cnt1, &s3d):one, *s3pb=s3p;
  char *s4p=s4?map_map(s4, 0, cnt1, &s4d):one, *s4pb=s4p;
  if (!k1) k1=zero;
  if (!k2) k2=zero;
  if (cnt2==4) {
/*    if (k2[0]==1&&k2[1]==1&&k2[2]==1&&k2[3]==1 && s4p==one)
      for (i=0; i<cnt1; i++) {
        ((float*)dp)[0]=((float*)s1p)[0]*((float*)s2p)[0]*k1[0]+((float*)s3p)[0];
        ((float*)dp)[1]=((float*)s1p)[1]*((float*)s2p)[1]*k1[1]+((float*)s3p)[1];
        ((float*)dp)[2]=((float*)s1p)[2]*((float*)s2p)[2]*k1[2]+((float*)s3p)[2];
        ((float*)dp)[3]=((float*)s1p)[3]*((float*)s2p)[3]*k1[3]+((float*)s3p)[3];
        dp+=dd; s1p+=s1d; s2p+=s2d; s3p+=s3d; s4p+=s4d;
      }
    else if (k2==zero)
      for (i=0; i<cnt1; i++) {
        ((float*)dp)[0]=((float*)s1p)[0]*((float*)s2p)[0]*k1[0];
        ((float*)dp)[1]=((float*)s1p)[1]*((float*)s2p)[1]*k1[1];
        ((float*)dp)[2]=((float*)s1p)[2]*((float*)s2p)[2]*k1[2];
        ((float*)dp)[3]=((float*)s1p)[3]*((float*)s2p)[3]*k1[3];
        dp+=dd; s1p+=s1d; s2p+=s2d; s3p+=s3d; s4p+=s4d;
      }
    else*/
      for (i=0; i<cnt1; i++) {
        ((float*)dp)[0]=((float*)s1p)[0]*((float*)s2p)[0]*k1[0]
                       +((float*)s3p)[0]*((float*)s4p)[0]*k2[0];
        ((float*)dp)[1]=((float*)s1p)[1]*((float*)s2p)[1]*k1[1]
                       +((float*)s3p)[1]*((float*)s4p)[1]*k2[1];
        ((float*)dp)[2]=((float*)s1p)[2]*((float*)s2p)[2]*k1[2]
                       +((float*)s3p)[2]*((float*)s4p)[2]*k2[2];
        ((float*)dp)[3]=((float*)s1p)[3]*((float*)s2p)[3]*k1[3]
                       +((float*)s3p)[3]*((float*)s4p)[3]*k2[3];
        dp+=dd; s1p+=s1d; s2p+=s2d; s3p+=s3d; s4p+=s4d;
      }
  } else {
    for (i=0; i<cnt1; i++) {
      for (j=0; j<cnt2; j++) 
        ((float*)dp)[j]=((float*)s1p)[j]*((float*)s2p)[j]*k1[j]
                       +((float*)s3p)[j]*((float*)s4p)[j]*k2[j];
      dp+=dd; s1p+=s1d; s2p+=s2d; s3p+=s3d; s4p+=s4d;
    }
  }
  if (s4) map_unmap(s4, s4pb);
  if (s3) map_unmap(s3, s3pb);
  if (s2) map_unmap(s2, s2pb);
  if (s1) map_unmap(s1, s1pb);
  map_unmap(d, dpb);
}


static inline int chunkid(char *p) { return *(unsigned short*)p; }
static inline int chunklen(char *p) { return *(int*)(p+2); }
static inline char *chunkend(char *p) { return p+chunklen(p); }



void demogroup_lue3ds(Demogroup *u, char *fname, int runk, int flags) {
  FILE *fp=fopen(fname, "rb");
  if (fp) {
    int l;
    char *mainc, *mainend; 
    fseek(fp, 0, SEEK_END); l=ftell(fp); fseek(fp, 0, SEEK_SET);
    mainc=malloc(l), mainend=mainc+l;
    fread(mainc, 1, l, fp);
    fclose(fp);
    if (chunkid(mainc)!=0x4d4d) { fprintf(stderr, "not a 3ds file"); return; }
    mainend=chunkend(mainc);
    for (mainc+=6; mainc<mainend; mainc=chunkend(mainc)) if (chunkid(mainc)==0x3d3d) {
      char *obuc, *obuend;
      mainend=chunkend(mainc);
      for (obuc=mainc+6; obuc<mainend; obuc=chunkend(obuc)) if (chunkid(obuc)==0x4000) {
        char *designc, *designend;
        static float ident[]={1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1};
        int vind, find;
        Design *m;
        Region *vp, *vt, *fi;
        obuend=chunkend(obuc);
        designc=obuc+6;
        m=demodesign(u->spc, strdup(designc), flags);
        vp=ind_get(m->verts, "pos"); 
        vt=ind_get(m->verts, "texture");
        fi=ind_get(m->faces, "index");
        vind=rgn_getsize(vp); find=rgn_getsize(fi);

        while (*designc) designc++;
        designc++;
        for (; designc<obuend; designc=chunkend(designc)) if (chunkid(designc)==0x4100) {
          designend=chunkend(designc);
          for (designc+=6; designc<designend; designc=chunkend(designc)) {
            if (chunkid(designc)==0x4110) {
              float *src=(float*)(designc+8);
              map_bfor (vp, float, v, vind, *(unsigned short*)(designc+6))
                v[0]=src[0]; v[1]=src[runk?2:1], v[2]=runk?-src[1]:src[2];
                if (runk==2) v[0]=-v[0], v[2]=-v[2];
                src+=3;
              map_efor (vp, v)
            } else if (chunkid(designc)==0x4140) {
              float *src=(float*)(designc+8);
              map_bfor (vt, float, t, vind, *(unsigned short*)(designc+6))
                t[0]=src[0]; t[1]=src[1];
                src+=2;
              map_efor (vt, t)
            } else if (chunkid(designc)==0x4120) {
              short *src=(short*)(designc+8);
              map_bfor (fi, short, f, find, *(unsigned short*)(designc+6))
                f[0]=src[0]+vind; f[1]=src[1]+vind; f[2]=src[2]+vind;
                src+=4;
              map_efor (fi, f)
            }
          }
          break;
        }
        design_calcnormals(m);
        group_add(u, m, ident);
      }
      break;
    }
    free(mainc);
  } else { fprintf(stderr, "file not found"); return; }
}


void demodesign_colourize(Demodesign *c, float *col) {
  int vc=rgn_getsize(c->vp);
  map_bfor (c->vc, float, i, 0, vc);
    i[0]=col[0]; i[1]=col[1]; i[2]=col[2]; i[3]=col[3];
  map_efor (c->vc, i);
  map_bfor (c->ve, float, i, 0, vc);
    i[0]=col[4]; i[1]=col[5]; i[2]=col[6]; i[3]=col[7];
  map_efor (c->ve, i);
  map_bfor (c->vl, float, i, 0, vc);
    i[0]=0; i[1]=0; i[2]=0; i[3]=0;
  map_efor (c->vl, i);
}


/*
void demodesign_dodif(Demodesign *c, float k1, float k2) {
  int i, j;
  unsigned short *f;
  int vc=rgn_getsize(c->vp);
  int vdd, vcd, vld, ved;
  char *vdp=rgn_map(c->vd, 0, vc, &vdd);
  char *vcp=rgn_map(c->vc, 0, vc, &vcd);
  char *vlp=rgn_map(c->vl, 0, vc, &vld);
  char *vep=rgn_map(c->ve, 0, vc, &ved);
  for (i=0; i<vc; i++) {
    float *d=(float*)(vdp+i*vdd), *c=(float*)(vcp+i*vcd), *l=(float*)(vlp+i*vld), *e=(float*)(vep+i*ved); 
    d[0]=l[0]*c[0]*k1+e[0]*k2; 
    d[1]=l[1]*c[1]*k1+e[1]*k2; 
    d[2]=l[2]*c[2]*k1+e[2]*k2; 
  }
  rgn_unmap(c->ve, vep);
  rgn_unmap(c->vd, vdp);
  rgn_unmap(c->vc, vcp);
  rgn_unmap(c->vl, vlp);
}
*/
static int kuvno=0;
void demodesign_doradio(Demodesign *c, Demogroup *g, float k) {
  int i, j;
  unsigned short *f;
  int vc=rgn_getsize(c->vp), fc=rgn_getsize(c->fi);
  int vpd, vnd, vld;
  unsigned char pdat[64*64*4];
  int listno;
  float *vdat=c->spc->squat(c->spc, 4*sizeof(float)*vc);
  i=0;
  {
  char *vlp=rgn_map(c->vl, 0, vc, &vld);
  char *vpp=rgn_map(c->vp, 0, vc, &vpd);
  char *vnp=rgn_map(c->vn, 0, vc, &vnd);


  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glColor4f(1/k, 1/k, 1/k, 1);
  glNewList(listno=glGenLists(1), GL_COMPILE);
    member_render(g);
  glEndList();

  for (i=0; i<vc*4; i++) vdat[i]=0;
  rgn_bfor(c->fi, short, f)
    float x=0, y=0, z=0;
    float *v0=(float*)(vpp+f[0]*vpd);
    float *v1=(float*)(vpp+f[1]*vpd);
    float *v2=(float*)(vpp+f[2]*vpd);
    x=(v0[0]+v1[0]+v2[0])*(1./3);
    y=(v0[1]+v1[1]+v2[1])*(1./3);
    z=(v0[2]+v1[2]+v2[2])*(1./3);
    vdat[f[0]*4+0]+=x; vdat[f[0]*4+1]+=y; vdat[f[0]*4+2]+=z; vdat[f[0]*4+3]+=1; 
    vdat[f[1]*4+0]+=x; vdat[f[1]*4+1]+=y; vdat[f[1]*4+2]+=z; vdat[f[1]*4+3]+=1; 
    vdat[f[2]*4+0]+=x; vdat[f[2]*4+1]+=y; vdat[f[2]*4+2]+=z; vdat[f[2]*4+3]+=1; 
  rgn_efor(c->fi, f)
  i=0;
  rgn_bfor(c->vp, float, v)
    vdat[i+0]=v[0]*.7+vdat[i+0]/vdat[i+3]*.3;
    vdat[i+1]=v[1]*.7+vdat[i+1]/vdat[i+3]*.3;
    vdat[i+2]=v[2]*.7+vdat[i+2]/vdat[i+3]*.3;
    i+=4;
  rgn_efor(c->vl, v)
  for (i=0; i<vc; i++) {
    float *pos=(float*)(vpp+i*vpd), *n=(float*)(vnp+i*vnd), *l=(float*)(vlp+i*vld); 
    float divver=0;
    glPushMatrix();
    glLoadIdentity();
//    gluLookAt(pos[0], pos[1], pos[2], pos[0]+n[0], pos[1]+n[1], pos[2]+n[2], 0.1, 1, 0.1);
    gluLookAt(vdat[i*4+0], vdat[i*4+1], vdat[i*4+2], vdat[i*4+0]+n[0], vdat[i*4+1]+n[1], vdat[i*4+2]+n[2], 0.1, 1, 0.1);
    glViewport((kuvno%10)*64, (kuvno/10)*64, 64, 64);
    glCallList(listno);
//    member_render(g);
    glReadPixels((kuvno%10)*64, (kuvno/10)*64, 64, 64, GL_RGBA, GL_UNSIGNED_BYTE, pdat);
    l[0]=l[1]=l[2]=0; l[3]=1;
    for (j=0; j<64*64; j++) {
      l[0]+=pdat[j*4+0];
      l[1]+=pdat[j*4+1];
      l[2]+=pdat[j*4+2];
      divver++;
    }
    divver=k/256./divver;
    l[0]*=divver; l[1]*=divver; l[2]*=divver;
    glPopMatrix();
    kuvno++;
    if (kuvno==70) { SDL_GL_SwapBuffers(); glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); kuvno=0; }
  }
  glPopAttrib();
  rgn_unmap(c->vl, vlp);
  rgn_unmap(c->vp, vpp);
  rgn_unmap(c->vn, vnp);
  }
  glDeleteLists(listno, 1);
  c->spc->abandon(c->spc, &vdat);
}

void demogroup_doradio(Demogroup *broncs, float k) {
  Region *cnt=broncs->norms.master.contents;
/*  rgn_bfor (cnt, Demodesign *, c)
    demodesign_dodif (*c, 1/k, 1);
  rgn_efor (cnt, c)*/
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  kuvno=0;
  rgn_bfor (cnt, Demodesign *, c)
    demodesign_doradio(*c, broncs, k);
  rgn_efor (cnt, c)
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPopAttrib();
/*  rgn_bfor (cnt, Demodesign *, c)
    demodesign_dodif (*c, 1, k);
  rgn_efor (cnt, c)*/
}




void design_unitize(Design *t) {
  float *v, x0, y0, z0, x1, y1, z1, xc, yc, zc, xs, ys, zs, s;
  int i;
  Region *vp=ind_get(t->verts, "pos");
  int vc=rgn_getsize(vp);
  int vdd;
  char *vd=rgn_map(vp, 0, vc, &vdd);
  v=(float*)vd;
  x0=x1=v[0]; y0=y1=v[1]; z0=z1=v[2]; 
  for (i=0; i<vc; i++) {
    v=(float*)(vd+i*vdd);
    if (v[0]<x0) x0=v[0]; else if (v[0]>x1) x1=v[0];
    if (v[1]<y0) y0=v[1]; else if (v[1]>y1) y1=v[1];
    if (v[2]<z0) z0=v[2]; else if (v[2]>z1) z1=v[2];
  }
  xs=x1-x0; ys=y1-y0; zs=z1-z0;
  xc=(x0+x1)*.5; yc=(y0+y1)*.5; zc=(z0+z1)*.5;
  s=2./(xs>ys && xs>zs?xs:ys>zs?ys:zs);
  for (i=0; i<vc; i++) {
    v=(float*)(vd+i*vdd);
    v[0]=(v[0]-xc)*s; v[1]=(v[1]-yc)*s; v[2]=(v[2]-zc)*s;
  }
  rgn_unmap(vp, vd);
}





void design_calcnormals(Design *t) {
  float *v0, *v1, *v2, *n0, *n1, *n2, nx, ny, nz, k;
  int i;
  unsigned short *f;
  Region *vp=ind_get(t->verts, "pos");
  Region *vn=ind_get(t->verts, "normal");
  Region *fi=ind_get(t->faces, "index");
  int vc=rgn_getsize(vp), fc=rgn_getsize(fi);
  int vpd, vnd, fid;
  char *vpp=rgn_map(vp, 0, vc, &vpd);
  char *vnp=rgn_map(vn, 0, vc, &vnd);
  char *fip=rgn_map(fi, 0, fc, &fid);
  for (i=0; i<vc; i++) {
    n0=(float*)(vnp+i*vnd); n0[0]=n0[1]=n0[2]=0;
  }
  for (i=0; i<fc; i++) {
    f=(unsigned short*)(fip+i*fid);
    v0=(float*)(vpp+f[0]*vpd);
    v1=(float*)(vpp+f[1]*vpd);
    v2=(float*)(vpp+f[2]*vpd);
    n0=(float*)(vnp+f[0]*vnd);
    n1=(float*)(vnp+f[1]*vnd);
    n2=(float*)(vnp+f[2]*vnd);
    nx=(v2[2]-v0[2])*(v1[1]-v0[1])-(v1[2]-v0[2])*(v2[1]-v0[1]);
    ny=(v2[0]-v0[0])*(v1[2]-v0[2])-(v1[0]-v0[0])*(v2[2]-v0[2]);
    nz=(v2[1]-v0[1])*(v1[0]-v0[0])-(v1[1]-v0[1])*(v2[0]-v0[0]);
//    if (nx==0 && ny==0 && nz==0) fprintf(stderr, "broken face\n");
    n0[0]+=nx; n0[1]+=ny; n0[2]+=nz;
    n1[0]+=nx; n1[1]+=ny; n1[2]+=nz;
    n2[0]+=nx; n2[1]+=ny; n2[2]+=nz;
  }
  for (i=0; i<vc; i++) {
    n0=(float*)(vnp+i*vnd); 
    k=n0[0]*n0[0]+n0[1]*n0[1]+n0[2]*n0[2];
    if (k>0) k=1./sqrt(k);
      else n0[0]=0, n0[1]=1, n0[2]=0;//fprintf(stderr, "lone vertex?\n");
    n0[0]*=k; n0[1]*=k; n0[2]*=k;
  }
  rgn_unmap(vp, vpp);
  rgn_unmap(vn, vnp);
  rgn_unmap(fi, fip);
}


static Member *glm_find(Member *d, char *handle) {
  return strcmp(d->handle, handle)==0?d:0;
}





static void glm_draw(Member *m) {
  Demodesign *g=(Demodesign*)m;
  int vcnt=rgn_getsize(g->vp), fcnt=rgn_getsize(g->fi);
  int vpd, vtd, vnd, vcd, fid;
  char *vpp, *vtp, *vnp, *vcp, *fip;
  float col[4];
  Region *vc=0;

  if (g->listno>=0) { glCallList(g->listno); return; }
  glPushClientAttrib(GL_ALL_CLIENT_ATTRIB_BITS);
  vpp=rgn_map(g->vp, 0, vcnt, &vpd); 
  glEnableClientState(GL_VERTEX_ARRAY);
  glVertexPointer(3, GL_FLOAT, vpd, vpp);

  vnp=rgn_map(g->vn, 0, vcnt, &vnd);
  glEnableClientState(GL_NORMAL_ARRAY);
  glNormalPointer(GL_FLOAT, vnd, vnp);
  if (rgn_getsize(g->vt)>0) {
    vtp=rgn_map(g->vt, 0, vcnt, &vtd);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);
    glTexCoordPointer(2, GL_FLOAT, vtd, vtp);
  } else glDisableClientState(GL_TEXTURE_COORD_ARRAY);
  glGetFloatv(GL_CURRENT_COLOR, col);
  if (rgn_getsize(g->vc)>0||rgn_getsize(g->vl)>0||rgn_getsize(g->ve)>0) {
    if (col[0]>.99 && col[1]>.99 && col[2]>.99 && col[3]>.99 && rgn_getsize(g->vl)==0 && rgn_getsize(g->ve)==0) 
      vc=g->vc;
    else {
      float ec[]={1,1,1,1};
      vc=spaceregion(g->spc, 4*sizeof(float), 0);
      map_fcalc(vc, rgn_getsize(g->vc)>0?g->vc:0, rgn_getsize(g->vl)>0?g->vl:0, col, rgn_getsize(g->ve)>0?g->ve:0, 0, rgn_getsize(g->ve)>0?ec:0, vcnt, 4);
    }
  }
  if (vc) {
    vcp=rgn_map(vc, 0, vcnt, &vcd);
    glEnableClientState(GL_COLOR_ARRAY);
    glColorPointer(4, GL_FLOAT, vcd, vcp);
  } else glDisableClientState(GL_COLOR_ARRAY);
  fip=rgn_map(g->fi, 0, fcnt, &fid);
  if (g->flags&1) glNewList(g->listno=glGenLists(1), GL_COMPILE_AND_EXECUTE);
  glDrawRangeElements(GL_TRIANGLES, 0, vcnt-1, fcnt*3, GL_UNSIGNED_SHORT, fip);
  if (g->flags&1) glEndList();
  rgn_unmap(g->fi, fip);
  if (vc) {
    rgn_unmap(vc, vcp);
    if (vc!=g->vc) inv_slaughter(vc), g->spc->abandon(g->spc, &vc);
  }
  if (rgn_getsize(g->vt)>0) rgn_unmap(g->vt, vtp);
  rgn_unmap(g->vn, vnp);
  rgn_unmap(g->vp, vpp);
  glPopClientAttrib();
  glColor4fv(col);
}

Demodesign *demodesign(Space *c, char *handle, int flags) {
  static Design_st st={{{"demodsng", worthless}, glm_find, glm_draw}};
  Demodesign *g=c->squat(c, sizeof(Demodesign));
  g->norms.Design=&st; 
  g->norms.master.norms.master.handle=handle;
  g->norms.master.verts=(Index*)(g->verts=spaceregister((Space*)c));
  g->norms.master.faces=(Index*)(g->faces=spaceregister((Space*)c));
  g->spc=c;
  g->flags=flags; g->listno=-1;
  reg_set(g->verts, "pos",     g->vp=spaceregion((Space*)c, 4*sizeof(float), 0));
  reg_set(g->verts, "normal",  g->vn=spaceregion((Space*)c, 4*sizeof(float), 0));
  reg_set(g->verts, "colour",  g->vc=spaceregion((Space*)c, 4*sizeof(float), 0));
  reg_set(g->verts, "light",   g->vl=spaceregion((Space*)c, 4*sizeof(float), 0));
  reg_set(g->verts, "emission", g->ve=spaceregion((Space*)c, 4*sizeof(float), 0));
  reg_set(g->verts, "texture", g->vt=spaceregion((Space*)c, 2*sizeof(float), 0));
  reg_set(g->faces, "index",   g->fi=spaceregion((Space*)c, 3*sizeof(short), 0));
  return (Design *)g;
}



static void demodesign_export(Demodesign *d, FILE *fp) {
  int cnt;
  cnt=rgn_getsize(d->vp); fwrite(&cnt, 1, sizeof(int), fp); rgn_bfor(d->vp, float, a) fwrite(a, 1, 4*sizeof(float), fp); rgn_efor(d->vp, a)
  cnt=rgn_getsize(d->vc); fwrite(&cnt, 1, sizeof(int), fp); rgn_bfor(d->vc, float, a) fwrite(a, 1, 4*sizeof(float), fp); rgn_efor(d->vc, a)
  cnt=rgn_getsize(d->vl); fwrite(&cnt, 1, sizeof(int), fp); rgn_bfor(d->vl, float, a) fwrite(a, 1, 4*sizeof(float), fp); rgn_efor(d->vl, a)
  cnt=rgn_getsize(d->ve); fwrite(&cnt, 1, sizeof(int), fp); rgn_bfor(d->ve, float, a) fwrite(a, 1, 4*sizeof(float), fp); rgn_efor(d->ve, a)
  cnt=rgn_getsize(d->vt); fwrite(&cnt, 1, sizeof(int), fp); rgn_bfor(d->vt, float, a) fwrite(a, 1, 2*sizeof(float), fp); rgn_efor(d->vt, a)
  cnt=rgn_getsize(d->fi); fwrite(&cnt, 1, sizeof(int), fp); rgn_bfor(d->fi, short, a) fwrite(a, 1, 3*sizeof(short), fp); rgn_efor(d->fi, a)
}
static void demodesign_import(Demodesign *d, FILE *fp) {
  int cnt;
  fread(&cnt, 1, sizeof(int), fp); map_bfor(d->vp, float, a, 0, cnt) fread(a, 1, 4*sizeof(float), fp); map_efor(d->vp, a)
  fread(&cnt, 1, sizeof(int), fp); map_bfor(d->vc, float, a, 0, cnt) fread(a, 1, 4*sizeof(float), fp); map_efor(d->vc, a)
  fread(&cnt, 1, sizeof(int), fp); map_bfor(d->vl, float, a, 0, cnt) fread(a, 1, 4*sizeof(float), fp); map_efor(d->vl, a)
  fread(&cnt, 1, sizeof(int), fp); map_bfor(d->ve, float, a, 0, cnt) fread(a, 1, 4*sizeof(float), fp); map_efor(d->ve, a)
  fread(&cnt, 1, sizeof(int), fp); map_bfor(d->vt, float, a, 0, cnt) fread(a, 1, 2*sizeof(float), fp); map_efor(d->vt, a)
  fread(&cnt, 1, sizeof(int), fp); map_bfor(d->fi, short, a, 0, cnt) fread(a, 1, 3*sizeof(short), fp); map_efor(d->fi, a)
  design_calcnormals(d);
}



static void demogroup_add(Group *u, Member *s, float *m) {
  int cnt=rgn_getsize(u->contents);
  int sd;
  char *sp=rgn_map(u->contents, cnt, 1, &sd);
  *(Member**)sp=s; memcpy(sp+4, m, 16*sizeof(float));
  rgn_unmap(u->contents, sp);
}

void demogroup_export(Group *g, FILE *fp) {
  int cnt=rgn_getsize(g->contents);
  fwrite(&cnt, 1, sizeof(int), fp);
  rgn_bfor(g->contents, Demodesign *, d)
    fprintf(fp, "%s\n", ((Member*)(*d))->handle);
    demodesign_export(*d, fp);
  rgn_efor(g->contents, d)
}
void demogroup_import(Group *g, FILE *fp, int flags) {
  int cnt;
  char nbuf[1000];
  fread(&cnt, 1, sizeof(int), fp);
  while (cnt--) {
    static float m[16]={1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
    Demodesign *d;
    fgets(nbuf, sizeof(nbuf), fp);
    if (*nbuf && nbuf[strlen(nbuf)-1]=='\n') nbuf[strlen(nbuf)-1]=0;
    d=demodesign(((Demogroup*)g)->spc, strdup(nbuf), flags);
    demodesign_import(d, fp);
    demogroup_add(g, d, m);
  }
}


static void demogroup_render(Member *s) {
  Group *u=(Group *)s;
  int cnt=rgn_getsize(u->contents);
  int sd, i;
  char *sp=rgn_map(u->contents, 0, cnt, &sd);
  for (i=0; i<cnt; i++) {
    glPushMatrix();
    glMultMatrixf((float*)(sp+i*sd+4));
    member_render(*(Member**)(sp+i*sd));
    glPopMatrix();
  }
  rgn_unmap(u->contents, sp);
}
static Member *grp_find(Group *g, char *handle) {
  rgn_bfor(g->contents, Demodesign *, c)
    Member *m=member_find(*c, handle);
    if (m) return m;
  rgn_efor(g->contents, c)
  return 0;
}
Demogroup *demogroup(Space *c, char *name) {
  static Group_st st={{{"demogrp", worthless}, grp_find, demogroup_render}, demogroup_add};
  Demogroup *u=c->squat(c, sizeof(Demogroup));
  u->norms.Group=&st;
  u->spc=c;
  u->norms.master.contents=spaceregion((Space*)c, sizeof(void*)+16*sizeof(float), 0);
  return u;
}




