#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "abstract.h"

#define DEBUG fprintf(stderr, "%i\n", __LINE__)



typedef struct _Memarray Memarray;
struct _Memarray {
  union { Arraycls *cls; Array super; } oo;
  Mem *m;
  int esize, len, alen;
  void *buf;
};




static int ma_getlen(Array *o) { return ((Memarray*)o)->len; }
static void ma_setlen(Array *o, int s) { 
  Memarray *a=(Memarray *)o;
  if (s>a->alen) a->m->realloc(a->m, &a->buf, (a->alen=s+(s>>4)+3&~3)*a->esize);
  a->len=s;
}
static void *ma_mmap(Map1d *o, int ind, int cnt, int *udelta) { 
  Memarray *a=(Memarray *)o;
  if (ind+cnt>a->len) ma_setlen((Array*)a, ind+cnt);
  *udelta=a->esize; return (char*)a->buf+ind*a->esize;
}
static void ma_munmap(Map1d *o, void *p) { }

Array *ma_create(Object *o, Mem *m, int elsize, int cnt) {
  Memarray *a=(Memarray *)o;
  static Arraycls ma_cls={
    { {0}, ma_mmap, ma_munmap }, 
    ma_getlen, ma_setlen, 
  };
  a->oo.cls=&ma_cls; a->m=m; a->esize=elsize; 
  if (cnt) a->buf=m->alloc(m, (a->len=a->alen=cnt)*a->esize); else a->len=a->alen=0, a->buf=0;
  return (Array*)a;
}
Array *memarray(Mem *m, int elsize, int cnt) { return ma_create(m->alloc(m, sizeof(Memarray)), m, elsize, cnt); }




//Design *design() { Design *r=calloc(sizeof(Design), 1); return r; }




typedef struct _Mrtree Mrtree;
struct _Mrtree {
  Mrtree *left, *right;
  char *nam;
  void *val;
};

void *mrt_get(Mrtree *t, char *n) { 
  int i;
  if (!t) return 0;
  i=strcmp(n, t->nam);
  return i==0?t->val:mrt_get(i<0?t->left:t->right, n);
}
void mrt_set(Mrtree **t, Mem *m, char *n, void *v) {
  int i;
  if (!*t) *t=m->alloc(m, sizeof(Mrtree)), (*t)->left=(*t)->right=0, (*t)->nam=strdup(n), i=0;
    else i=strcmp(n, (*t)->nam);
  if (i==0) (*t)->val=v;
    else mrt_set(i<0?&((*t)->left):&((*t)->right), m, n, v);
}


typedef struct _Memregister Memregister;
struct _Memregister {
  union { Registercls *cls; Register super; } oo;
  Mem *m;
  Mrtree *root;
};

void *mr_get(Index *o, char *n) { Memregister *r=(Memregister*)o; return mrt_get(r->root, n); }
char *mr_next(Index *o, char *n) { Memregister *r=(Memregister*)o; }
int mr_exists(Index *o, char *n) { Memregister *r=(Memregister*)o; }
void mr_set(Register *o, char *n, void *v) { Memregister *r=(Memregister*)o; mrt_set(&r->root, r->m, n, v); }
void mr_remove(Register *o, char *n) { Memregister *r=(Memregister*)o; }

Register *memregister(Mem *m) {
  static Registercls cls={{{0}, mr_get, mr_next, mr_exists}, mr_set, mr_remove};
  Memregister *r=m->alloc(m, sizeof(Memregister));
  r->oo.cls=&cls; r->m=m;
  return (Register*)r;
}






typedef struct _Demodesign Demodesign;
struct _Demodesign {
  union { Designcls *cls; Design super; } oo;
  Register *verts, *faces;
  Array *vp, *vn, *vc, *vl, *vt, *fi;
};


Design *demodesign(Mem *m) {
  static Designcls cls={{0}};
  Demodesign *g=m->alloc(m, sizeof(Demodesign));
  g->oo.cls=&cls; 
  g->oo.super.verts=(Index*)(g->verts=memregister(m));
  g->oo.super.faces=(Index*)(g->faces=memregister(m));
  reg_set(g->verts, "pos",     g->vp=memarray(m, 4*sizeof(float), 0));
  reg_set(g->verts, "normal",  g->vn=memarray(m, 4*sizeof(float), 0));
  reg_set(g->verts, "color",   g->vc=memarray(m, 4*sizeof(float), 0));
  reg_set(g->verts, "light",   g->vl=memarray(m, 4*sizeof(float), 0));
  reg_set(g->verts, "texture", g->vt=memarray(m, 2*sizeof(float), 0));
  reg_set(g->faces, "index",   g->fi=memarray(m, 3*sizeof(short), 0));
  return (Design *)g;
}



static inline int chunkid(char *p) { return *(unsigned short*)p; }
static inline int chunklen(char *p) { return *(int*)(p+2); }
static inline char *chunkend(char *p) { return p+chunklen(p); }

void cpy(void *d, int dd, void *s, int sd, int esize, int cnt) {
  int i;
  for (i=0; i<cnt; i++) memcpy((char*)d+i*dd, (char*)s+i*sd, esize);
}




void design_lue3ds(Design *m, char *fname) {
  FILE *fp=fopen(fname, "rb");
  if (fp) {
    int l;
    char *mainc, *mainend; 
    Array *vp=ind_get(m->verts, "pos"), 
         // *vn=ind_get(m->verts, "normal"), 
         // *vc=ind_get(m->verts, "color"), 
         // *vl=ind_get(m->verts, "light"), 
          *vt=ind_get(m->verts, "texture"), 
          *fi=ind_get(m->faces, "index");
    fseek(fp, 0, SEEK_END); l=ftell(fp); fseek(fp, 0, SEEK_SET);
    mainc=malloc(l), mainend=mainc+l;
    fread(mainc, 1, l, fp);
    fclose(fp);
    if (chunkid(mainc)!=0x4d4d) { fprintf(stderr, "not a 3ds file"); return; }
    mainend=chunkend(mainc);
    for (mainc+=6; mainc<mainend; mainc=chunkend(mainc)) if (chunkid(mainc)==0x3d3d) {
      char *obuc, *obuend;
      mainend=chunkend(mainc);
      for (obuc=mainc+6; obuc<mainend; obuc=chunkend(obuc)) if (chunkid(obuc)==0x4000) {
        char *designc, *designend;
        int vind=arr_getlen(vp), find=arr_getlen(fi);
        obuend=chunkend(obuc);
        designc=obuc+6;
        while (*designc) designc++;
        designc++;
        
        for (; designc<obuend; designc=chunkend(designc)) if (chunkid(designc)==0x4100) {
          designend=chunkend(designc);
          for (designc+=6; designc<designend; designc=chunkend(designc)) {
            if (chunkid(designc)==0x4110) {
              int cnt=*(unsigned short*)(designc+6), dd;
              char *d=arr_mmap(vp, vind, cnt, &dd);
              cpy(d, dd, designc+8, 3*sizeof(float), 3*sizeof(float), cnt);
              arr_munmap(vp, d);
            } else if (chunkid(designc)==0x4140) {
              int cnt=*(unsigned short*)(designc+6), dd;
              char *d=arr_mmap(vt, vind, cnt, &dd);
              cpy(d, dd, designc+8, 2*sizeof(float), 2*sizeof(float), cnt);
              arr_munmap(vt, d);
            } else if (chunkid(designc)==0x4120) {
              int cnt=*(unsigned short*)(designc+6), dd;
              char *d=arr_mmap(fi, find, cnt, &dd);
              cpy(d, dd, designc+8, 4*sizeof(short), 3*sizeof(short), cnt);
              { int i; for (i=0; i<cnt; i++) { short *p=(short*)(d+i*dd); p[0]+=vind, p[1]+=vind, p[2]+=vind; } }
              arr_munmap(fi, d);
            }
          }
//          return;
          break;
        }
      }
      break;
    }
    free(mainc);
  } else { fprintf(stderr, "file not found"); return; }
}





/*


static inline int chunkid(char *p) { return *(unsigned short*)p; }
static inline int chunklen(char *p) { return *(int*)(p+2); }
static inline char *chunkend(char *p) { return p+chunklen(p); }


Design *lue3ds(struct obstack *obs, char *fname) {
  Design *juuri=0;
  FILE *fp=fopen(fname, "rb");
  if (fp) {
    int l, i;
    char *mainc, *mainend; 
    fseek(fp, 0, SEEK_END); l=ftell(fp); fseek(fp, 0, SEEK_SET);
    mainc=obstack_alloc(obs, l), mainend=mainc+l;
    fread(mainc, 1, l, fp);
    fclose(fp);
    if (chunkid(mainc)!=0x4d4d) { fprintf(stderr, "not a 3ds file"); return 0; }
    mainend=chunkend(mainc);
    for (mainc+=6; mainc<mainend; mainc=chunkend(mainc)) if (chunkid(mainc)==0x3d3d) {
      char *obuc, *obuend;
      mainend=chunkend(mainc);
      for (obuc=mainc+6; obuc<mainend; obuc=chunkend(obuc)) if (chunkid(obuc)==0x4000) {
        char *designc, *designend;
        obuend=chunkend(obuc);
        designc=obuc+6;
        //printf("obu %s\n", designc);
        while (*designc) designc++;
        designc++;
        for (; designc<obuend; designc=chunkend(designc)) if (chunkid(designc)==0x4100) {
          int vc=0, fc=0;
          Design *t=Design();
          designend=chunkend(designc);
          for (designc+=6; designc<designend; designc=chunkend(designc)) {
//            printf("%x %i\n", chunkid(designc), chunklen(designc));
            if (chunkid(designc)==0x4110) {
              vc=*(unsigned short*)(designc+6);
//              printf("vp: %i\n", vc);
              t->vp=holyarr(obs, designc+8, sizeof(float)*3, vc);
//              for (i=0; i<vc; i++) printf("%f\n", ha_index(t->vp, i, float));
            } else if (chunkid(designc)==0x4140) {
              vc=*(unsigned short*)(designc+6);
//              printf("vt: %i\n", vc);
              t->vt=holyarr(obs, designc+8, sizeof(float)*2, vc);
            } else if (chunkid(designc)==0x4120) {
              fc=*(unsigned short*)(designc+6);
//              printf("f: %i\n", fc);
//              t->f=holyarr(obs, designc+8, sizeof(short)*4, fc);
              t->f=holyarr(obs, 0, sizeof(short)*3, fc);
              for (i=0; i<fc; i++) 
                ((short*)ha_indexp(t->f, i))[0]=((short*)(designc+8))[i*4+0], 
                ((short*)ha_indexp(t->f, i))[1]=((short*)(designc+8))[i*4+1], 
                ((short*)ha_indexp(t->f, i))[2]=((short*)(designc+8))[i*4+2];
//                printf("%i %i %i\n", ((short*)(designc+8))[i*4+0], ((short*)(designc+8))[i*4+1], ((short*)(designc+8))[i*4+2]);
            }
          }
          t->next=juuri;
          juuri=t;
          break;
        }
      }
      break;
    }
//    return r;
  } else { fprintf(stderr, "file not found"); return 0; }
  return juuri;
}
*/


void design_unitize(Design *t) {
  float *v, x0, y0, z0, x1, y1, z1, xc, yc, zc, xs, ys, zs, s;
  int i;
  Array *vp=ind_get(t->verts, "pos");
  int vc=arr_getlen(vp);
  int vdd;
  char *vd=arr_mmap(vp, 0, vc, &vdd);
  v=(float*)(vd+i*vdd);
  x0=x1=v[0]; y0=y1=v[1]; z0=z1=v[2]; 
  for (i=0; i<vc; i++) {
    v=(float*)(vd+i*vdd);
    if (v[0]<x0) x0=v[0]; else if (v[0]>x1) x1=v[0];
    if (v[1]<y0) y0=v[1]; else if (v[1]>y1) y1=v[1];
    if (v[2]<z0) z0=v[2]; else if (v[2]>z1) z1=v[2];
  }
  xs=x1-x0; ys=y1-y0; zs=z1-z0;
  xc=(x0+x1)*.5; yc=(y0+y1)*.5; zc=(z0+z1)*.5;
  s=2./(xs>ys &&&& xs>zs?xs:ys>zs?ys:zs);
  for (i=0; i<vc; i++) {
    v=(float*)(vd+i*vdd);
    v[0]=(v[0]-xc)*s; v[1]=(v[1]-yc)*s; v[2]=(v[2]-zc)*s;
  }
  arr_munmap(vp, vd);
}





void design_calcnormals(Design *t) {
  float *v, x0, y0, z0, x1, y1, z1, xc, yc, zc, xs, ys, zs, s;
  int i;
  Array *vp=ind_get(t->verts, "pos");
  int vc=arr_getlen(vp);
  int vdd;
  char *vd=arr_mmap(vp, 0, vc, &vdd);
  v=(float*)(vd+i*vdd);
  x0=x1=v[0]; y0=y1=v[1]; z0=z1=v[2]; 
  for (i=0; i<fc; i++) {
    v=(float*)(vd+i*vdd);
    if (v[0]<x0) x0=v[0]; else if (v[0]>x1) x1=v[0];
    if (v[1]<y0) y0=v[1]; else if (v[1]>y1) y1=v[1];
    if (v[2]<z0) z0=v[2]; else if (v[2]>z1) z1=v[2];
  }
  xs=x1-x0; ys=y1-y0; zs=z1-z0;
  xc=(x0+x1)*.5; yc=(y0+y1)*.5; zc=(z0+z1)*.5;
  s=2./(xs>ys &&&& xs>zs?xs:ys>zs?ys:zs);
  for (i=0; i<vc; i++) {
    v=(float*)(vd+i*vdd);
    v[0]=(v[0]-xc)*s; v[1]=(v[1]-yc)*s; v[2]=(v[2]-zc)*s;
  }
  arr_munmap(vp, vd);
}








