#define _GNU_SOURCE

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <jpeglib.h>
#include "anarchy.h"
#include "scene.h"
#include <SDL/SDL.h>
#include "jobs.h"


void vipfun(float *pos, float t, float t2, float *par) {
  pos[0]=cos(t*1.345345);
  pos[1]=sin(t*1.67444);
  pos[2]=cos(t*1.744334);
  pos[3]=.01;
}


Movie *anki;
Demogroup *segis, *corn, *tori1, *tori2, *disk, *eukko, *surge, *corba, *boel;
Demodesign *klimp, *kvirr;
Demodesign *blob;
Demogroup *syrka, *seina, *tekti;
void prekalki(Space *s) {
  int i=0;
  klimp=demodesign(s,"",0);
  kvirr=demodesign(s,"",0);
  blob=demodesign(s,"",0);
/*  makeblob(klimp, 10, 20);
  vobl(klimp, 0, 0.5, 10);*/
/*
  syrka=demogroup(s, "");
  demogroup_lue3ds(syrka, "models/surk.3ds", 1, 0);
  {
    float col0[8]={0,0,0,1, 1,1,1,1};
    float col1[8]={.4,.5,.4,1, 0,0,0,1};
    float col2[8]={.8,.8,.8,1, 0,0,0,1};
    float col3[8]={.6,.5,.5,1, 0,0,0,1};
    float col4[8]={.8,.8,.8,1, .2,.2,.2,1};
    float col5[8]={.6,.5,.5,1, .03,.03,.03,1};

    demodesign_colourize(member_find(syrka, "ikkun"), col0);
    demodesign_colourize(member_find(syrka, "latti"), col1);
    demodesign_colourize(member_find(syrka, "sein"), col2);
    demodesign_colourize(member_find(syrka, "kattok"), col3);
    demodesign_colourize(member_find(syrka, "kupo"), col5);
    demodesign_colourize(member_find(syrka, "iko"), col4);
  }
*/

/*  syrka=demogroup(s, "");
  demogroup_lue3ds(syrka, "models/gurkf.3ds", 1, 0);
  {
    float col0[8]={0,0,0,1, 1,1,1,1};
    float col1[8]={.35,.37,.35,1, 0,0,0,1};
    float col2[8]={.8,.8,.8,1, 0,0,0,1};
    float col3[8]={.6,.55,.55,1, 0,0,0,1};
    float col4[8]={.9,.9,.9,1, .2,.2,.2,1};
    float col5[8]={.55,.5,.5,1, .03,.03,.03,1};
    float col6[8]={.85,.85,.85,1, 0,0,0,1};
    demodesign_colourize(member_find(syrka, "ikkun"), col0);
    demodesign_colourize(member_find(syrka, "latti"), col1);
    demodesign_colourize(member_find(syrka, "sein"), col2);
    demodesign_colourize(member_find(syrka, "ptolp"), col6);
    demodesign_colourize(member_find(syrka, "kaar"), col6);
    demodesign_colourize(member_find(syrka, "ktolp"), col6);
    demodesign_colourize(member_find(syrka, "paat"), col2);
    demodesign_colourize(member_find(syrka, "kattok"), col3);
    demodesign_colourize(member_find(syrka, "kupo"), col5);
    demodesign_colourize(member_find(syrka, "iko"), col4);
  }*/
  {  
    FILE *fp=fopen("anki.dat", "r");
    anki=readmovie(fp);
    fclose(fp);
  }
  {
    FILE *fp=fopen("church.dat", "r");
    demogroup_import(syrka=demogroup(s, "kirk"), fp, 1);
    fclose(fp);
    domapcoord(member_find(syrka, "latti" ), 1,0,0,0, 0,0,1,0);
    lightmul(member_find(syrka,   "latti" ),2.5,-.2);
    domapcoord(member_find(syrka, "kattok"), .25,0,0,0, 0,0,.25,0);
    lightmul(member_find(syrka,   "kattok"),2.5,-.2);
    domapcoord(member_find(syrka, "kupo"  ), .15,0,0,0, 0,0,.15,0);
    lightmul(member_find(syrka,   "kupo"  ),2.5,-.2);
    domapcoord(member_find(syrka, "iko"   ), .15,0,0,.5, 0,-.07,0,.2);
    lightmul(member_find(syrka,   "iko"   ),2.5,-.2);
    domapcoord(member_find(syrka, "sein"  ), .7,0,.1,0, 0,.5,0,0);
    lightmul(member_find(syrka,   "sein"  ),2.5,-.2);
    domapcoord(member_find(syrka, "ptolp" ), .7,0,.1,0, 0,.5,0,0);
    lightmul(member_find(syrka,   "ptolp" ),2.5,-.2);
    domapcoord(member_find(syrka, "kaar"  ), .7,0,.1,0, 0,.5,0,0);
    lightmul(member_find(syrka,   "kaar"  ),2.5,-.2);
    domapcoord(member_find(syrka, "ktolp" ), .7,0,.1,0, 0,.5,0,0);
    lightmul(member_find(syrka,   "ktolp" ),2.5,-.2);
    domapcoord(member_find(syrka, "paat"  ), .5,0,.5,0, 0,.5,0,0);
    lightmul(member_find(syrka,   "paat"  ),2.5,-.2);
    domapcoord(member_find(syrka, "ikkun" ), .7,0,.1,0, 0,.5,0,0);
    lightmul(member_find(syrka,   "ikkun" ),2.5,-.2);
  }
/*
  esker=demogroup(s, "");
  demogroup_lue3ds(esker, "models/escherx.3ds", 1, 0);
//  design_calcnormals(esker);
//  design_unitize(esker);
*/
  tori1=demogroup(s, "");
  demogroup_lue3ds(tori1, "models/tor_1.3ds", 1, 1);

  tori2=demogroup(s, "");
  demogroup_lue3ds(tori2, "models/tor_3b.3ds", 1, 1);
/*
  disk=demogroup(s, "");
  demogroup_lue3ds(disk, "models/disk_o.3ds", 1, 1);
*/
  eukko=demogroup(s, "");
  demogroup_lue3ds(eukko, "models/lentoeukko2c.3ds", 1, 1);

  surge=demogroup(s, "");
  demogroup_lue3ds(surge, "models/surge.3ds", 1, 1);

  corba=demogroup(s, "");
  demogroup_lue3ds(corba, "models/boomboxf.3ds", 2, 1);

  boel=demogroup(s, "");
  demogroup_lue3ds(boel, "models/bev2.3ds", 1, 1);
/*
  corn=demogroup(s, "");
  demogroup_lue3ds(corn, "models/corntess.3ds", 1, 0);
*/
/*
  {
    float valo[8]={0,0,0,1, 1,1,1,1};
    float paska[8]={.8,.8,.8,1, 0,0,0,1};
    float lootat[8]={.8,.8,.8,1, 0,0,0,1};
    float pun[8]={.9,.5,.5,1, 0,0,0,1};
    float vih[8]={.5,.9,.5,1, 0,0,0,1};
    demodesign_colourize(member_find(corn, "valo"), valo);
    demodesign_colourize(member_find(corn, "paska"), paska);
    demodesign_colourize(member_find(corn, "lootat"), lootat);
    demodesign_colourize(member_find(corn, "pun"), pun);
    demodesign_colourize(member_find(corn, "vih"), vih);
  }*/
//  design_calcnormals(corn);
//  design_unitize(corn);

/*
  seina=demogroup(s, "");
  group_add(seina, segis, xlat(0, 0, -0*.54));
  group_add(seina, segis, xlat(0, 0, -1*.54));
  group_add(seina, segis, xlat(0, 0, -2*.54));
  group_add(seina, segis, xlat(0, 0, -3*.54));
  group_add(seina, segis, xlat(0, 0, -4*.54));
  group_add(seina, segis, xlat(0, 0, -5*.54));
  group_add(seina, segis, xlat(0, 0, -6*.54));
  syrka=demogroup(s, "");
  group_add(syrka, seina, xlat( 0.75, 0, 0));
  group_add(syrka, seina, xlat(-0.75, 0, 0));
*/  
}



void glhuora(int huoranro, float r, float g, float b, float a, float xs, float ys, float zr) {
  float split1=0;
  float split2=0;

  if (huoranro==0) {
    split1=0;
    split2=0.5;
  } else if (huoranro==1) {
    split1=0;
    split2=0;
  } else if (huoranro==2) {
    split1=0.5;
    split2=0;
  } else if (huoranro==3) {
    split1=0.0;
    split2=0.5;
  } else if (huoranro==4) {
    split1=0;
    split2=0;
  } else if (huoranro==5) {
    split1=0.5;
    split2=0;
  } else if (huoranro==6) {
    split1=0;
    split2=0;
  } else if (huoranro==7) {
    split1=0.5;
    split2=0;
  } else if (huoranro==8) {
    split1=0.5;
    split2=0;
  } else if (huoranro==9) {
    split1=0;
    split2=0;
  } else {
    split1=0;
    split2=0;
  }

  glpushad();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glViewport(0, 0, 640, 480);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_NORMALIZE);
  glDisable(GL_CULL_FACE);
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
  glBindTexture(GL_TEXTURE_2D, huoranro);
  glColor4f(r, g, b, 1-a);
  glRotatef(360*zr, 0, 0, 1);
  glBegin(GL_QUAD_STRIP);
  glTexCoord2f(.005, .005); glVertex2f(-xs,  ys);
  glTexCoord2f(.005, .995); glVertex2f(-xs, -ys);
  if (split1>0) {
    glTexCoord2f(.005, .005); glVertex2f((split1*2-1)*xs,  ys);
    glTexCoord2f(.005, .995); glVertex2f((split1*2-1)*xs, -ys);
  }
  if (split2>0) {
    glTexCoord2f(.995, .005); glVertex2f((1-split2*2)*xs,  ys);
    glTexCoord2f(.995, .995); glVertex2f((1-split2*2)*xs, -ys);
  }
  glTexCoord2f(.995, .005); glVertex2f( xs,  ys);
  glTexCoord2f(.995, .995); glVertex2f( xs, -ys);
  glEnd();
  glpopad();
}
void glxhuora(int huoranro, float r, float g, float b, float a, float xs, float ys, float xp, float yp, float xpan, float ypan, int mode) {
//  doview(.75, 0, 0);
  glpushad();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glViewport(0, 0, 640, 480);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_NORMALIZE);
  glEnable(GL_BLEND);
  if(mode==0) {
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glBindTexture(GL_TEXTURE_2D, huoranro);
    glColor4f(r, g, b, a);
  } else if (mode==1) {
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glBindTexture(GL_TEXTURE_2D, huoranro);
    glColor4f(r, g, b, 1-a);
  } else {
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glBindTexture(GL_TEXTURE_2D, huoranro);
    glColor4f(r, g, b, 1-a);
  }
//  glTranslatef(1, -0.6667, 0);
//  glScalef(2+r*0.0125, 2, 1);
//  glTranslatef(-(xp/640), (yp/480)*0.6667, 0);
//  glPushMatrix();
  glTranslatef(xpan, ypan, 0);
//  glPopMatrix();
  glBegin(GL_QUADS);
  glTexCoord2f(.005, .005); glVertex2f(-xs,  ys);
  glTexCoord2f(.005, .995); glVertex2f(-xs, -ys);
  glTexCoord2f(.995, .995); glVertex2f( xs, -ys);
  glTexCoord2f(.995, .005); glVertex2f( xs,  ys);
  glEnd();
  glpopad();
}
void glhuora_rlow(int huoranro, float r, float g, float b, float a, float xs, float ys, float xp, float yp) {
  glpushad();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glViewport(0, 0, 640, 480);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_NORMALIZE);
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
  glBindTexture(GL_TEXTURE_2D, huoranro);
  glColor4f(r, g, b, 1-a);
  glTranslatef(1, -0.6667, 0);
  glScalef(2+r*0.0125, 2, 1);
  glTranslatef(-(xp/640+0.01), (yp/480)*0.6667, 0);
  glBegin(GL_QUADS);
  glTexCoord2f(.005, .005); glVertex2f(-xs,  ys);
  glTexCoord2f(.005, .995); glVertex2f(-xs, -ys);
  glTexCoord2f(.995, .995); glVertex2f( xs, -ys);
  glTexCoord2f(.995, .005); glVertex2f( xs,  ys);
  glEnd();
  glpopad();
}


void glRadial(int tex, int depth, float bri, float scale, float xpos, float ypos) {
  int i;
  for (i=0;i<depth;i++) {
    glhuora(tex, (1.0/depth)*bri, (1.0/depth)*bri, (1.0/depth)*bri, 1.0, 1+0.1*(scale*1/i), 0.567+0.1*(scale*1/i), 0);
  }
}
void glRadial2(int tex, int depth, float bri, float scale, float xpos, float ypos) {
  int i;
  for (i=0;i<depth;i++) {
    glhuora(tex, (1.0/depth)*bri, (1.0/depth)*bri, (1.0/depth)*bri, 1.0, 1+scale*i, 0.567+scale*i, 0);
  }
}

void glKredut(int tex, float t, float len) {
  float bri=1;
  float britelite=1;
  float x;
  float y;
  t=fmod(t*2, 1);
  if (t<0) return;
  if (t>1) return;
  britelite=((1/t)-1)*(bri*0.25);
  if (tex==10) {
    x=128;
    y=64;
  } else if (tex==11) {
    x=128;
    y=64;
  } else if (tex==12) {
    x=256;
    y=64;
  } else if (tex==13) {
    x=128;
    y=64;
  } else if (tex==14) {
    x=128;
    y=64;
  } else if (tex==15) {
    x=128;
    y=64;
  }
  glhuora_rlow(tex, britelite, britelite, britelite, 1.0, 1.0*x/640.0, 0.667*y/480.0, x, y);  
}

void glImgStrobe(int tex, float t, float bri, float len) {
  float britelite;
  t=t*(16/len);
  if (t<0) return;
  if (t>1) return;
  britelite=((1/t)-1)*(bri*0.25);
  glhuora(tex, britelite, britelite, britelite, 1.0, 1, 0.667, 0);
}

void glSnareBuild(int tex, float t, float bri, float frequ, float sharpness) {
  glImgStrobe(tex, fmod(t, (1/frequ)/16.0), bri*bri, 1.0/(frequ*sharpness));
}


void kiksublob(float t, float size, float pos, float rate, float frequency, float xpos) {
  int i=1;
  int kludge=GL_SPHERE_MAP;
  glpushad();

  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_NORMALIZE);
  glEnable(GL_BLEND);

  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glTexGeniv(GL_S, GL_TEXTURE_GEN_MODE, &kludge);
  glTexGeniv(GL_T, GL_TEXTURE_GEN_MODE, &kludge);
  glEnable(GL_TEXTURE_GEN_S);
  glEnable(GL_TEXTURE_GEN_T);
  glMatrixMode(GL_TEXTURE);
  glPushMatrix();
  glTranslatef(0, t*8, 0);
  glMatrixMode(GL_MODELVIEW);
  glBindTexture(GL_TEXTURE_2D, 9);
//  glColor4f(1, 1.0, 1.0, 1.0);  
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
//  glBindTexture(GL_TEXTURE_2D, 8);
  glColor4f(0.5+0.5*sin(t), 1.0, 1.0, 1.0);
  gluLookAt(cos(t*1.456465), sin(t*1.1354634)+.5, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
  glTranslatef(0, -2*(sin(t*1.1354634)+.5), 0);
  glScalef(0.2, 0.1+0.9*(sin(t*1.1354634)+.5), 0.2);
//  glTranslatef(xpos, 0, 0);
//  gluLookAt(cos(t*1.456465)*5, sin(t*1.1354634)*5, sin(t*1.945245)*5, 0, 0, 0, 0, 1, 0);
  glRotatef(t*360, 0.327, 0.5, 0);
  for (i=0;i<5;i++) {
    glRotatef((pos*0.36*i), 0, 0.5, 0.9);
    glScalef(size+i*0.005, size+i*0.005, size+i*0.005);
    makesphere(blob, 8, 16, .1, .5);
    vobl(blob, pos, rate+i*0.01, frequency+i*0.05);
    member_render(blob);
  }
  glPopMatrix();
  glMatrixMode(GL_TEXTURE);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);
  glpopad();
}

void tunel(float t) {
  int i;
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glDisable(GL_LIGHTING);
  glBindTexture(GL_TEXTURE_2D, 9);
  glColor4f(0.5+0.5*sin(t), 1.0, 1.0, 1.0);
  gluLookAt(cos(t*1.456465), sin(t*1.1354634)+.5, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
  makecyl(klimp, 12, 24, 2, -25, t*8); distfade(klimp, 0,0,0, 10);
  member_render(klimp);
  glPopAttrib();
}

void tunel2(float t, float rad, float bri, int pat, int row) {
  int i;
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glDisable(GL_LIGHTING);
  glBindTexture(GL_TEXTURE_2D, 9);
  glColor4f(0.5+0.5*sin(t), 1.0, 1.0, 1.0);
  if (pat>=8 && pat<12) {
    if (row>=22 && row<28) {
      gluLookAt(cos(t*1.456465)*(1-0.9*(fmod((t*16+22), 1))), sin(t*1.1354634)+.5+(fmod((t*16+22), 1))*0.25, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
    } else if (row>=28 && row<36) {
      gluLookAt(cos(t*1.456465)*(1-0.9*(fmod((t*16+28), 1))), sin(t*1.1354634)+.5+(fmod((t*16+28), 1))*0.25, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
    } else if (row>=86 && row<92) {
      gluLookAt(cos(t*1.456465)*(1-0.9*(fmod((t*16+86), 1))), sin(t*1.1354634)+.5+(fmod((t*16+86), 1))*0.25, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
    } else if (row>=92 && row<100) {
      gluLookAt(cos(t*1.456465)*(1-0.9*(fmod((t*16+92), 1))), sin(t*1.1354634)+.5+(fmod((t*16+92), 1))*0.25, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
    } else {
      gluLookAt(cos(t*1.456465), sin(t*1.1354634)+.5, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
    }
  } else {
    gluLookAt(cos(t*1.456465), sin(t*1.1354634)+.5, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
  }
  makecyl(klimp, 12, 24, 2, -25, t*8); distfade(klimp, 0,0,0, 10);
  member_render(klimp);
  glPopAttrib();
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_NORMALIZE);
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
  glBindTexture(GL_TEXTURE_2D, 19);
  glColor4f(1.0*bri*bri, 1.0*bri*bri, 1.0*bri, 0);
  makecyl(klimp, 12, 24, rad*0.5, -25, t*8);
  member_render(klimp);
  glPopAttrib();
}

void effu() {
/*  glBindTexture(GL_TEXTURE_2D, 0);
  glEnable(GL_TEXTURE_2D);
//  glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, 640, 480);
//  glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB5, 0, 0, 64, 64, 0);
  glhuora(0, 1, 1, 1, 1, 1, 1, 0);*/
}

void surgetxt(float t) {
  int x=256;
  int y=128;
  float fd;
  float fd2;
  glpushad();
  if(t>=4&&t<6) {
    fd=1-((t-4)*0.5);
    fd2=fd*fd;
    fd=fd*fd*fd;
    x=128;
    y=64;
    glxhuora(17, fd, fd, fd, 1, 1.0*x/640.0, 0.667*y/480.0, x, y, 0.5-(t-4)*0.5, 0.18,1);  
    x=256;
    y=128;
    glxhuora(16, fd2, fd2, fd2, 1, 1.0*(x/640.0+0.2), 0.667*(y/480.0+0.05), x, y, 0.02, 0.0,1);  
    x=256;
    y=64;
    glxhuora(18, fd, fd, fd, 1, 1.0*x/640.0, 0.667*y/480.0, x, y,  -0.5+(t-4)*0.5, -0.21,1);  
  } else if(t>=6&&t<8) {
    fd=1-((t-6)*0.5);
    fd2=fd*fd;
    fd=fd*fd*fd;
    x=128;
    y=64;
    glxhuora(21, fd, fd, fd, 1, 1.0*x/640.0, 0.667*y/480.0, x, y, 0.5-(t-6)*0.5, 0.18-0.05,1);  
    x=256;
    y=128;
    glxhuora(22, fd2, fd2, fd2, 1, 1.0*(x/640.0+0.2), 0.667*(y/480.0+0.05), x, y, 0.25, 0.0-0.05,1);  
    x=128;
    y=64;
    glxhuora(23, fd, fd, fd, 1, 1.0*x/640.0, 0.667*y/480.0, x, y,  -0.5+(t-6)*0.5, -0.21-0.05,1);  
  }
  glpopad();
}
void numedia(float t) {
  int x=2048;
  int y=256;
  float fd;
  float fd2;
  glpushad();
    fd=(1-(fmod(t*16,1)));
    fd2=fd*fd;
    fd=(fd*fd*fd*0.75)+fd*0.25;
    glMatrixMode(GL_TEXTURE);
      glScalef(10,1,1);
    glMatrixMode(GL_MODELVIEW);
    glxhuora(24, fd, fd, fd, 1, 1.0*x/640.0*16, 0.625*y/480.0*2, x, y, t*2, 0,1);  
    
  glpopad();
}
void numedia2(float t) {
  int x=2048;
  int y=256;
  float fd;
  float fd2;
  glpushad();
    fd=(1-(fmod(t*16,1)));
    fd2=fd*fd;
    fd=(fd*fd*fd*0.75)+fd*0.25;
    glMatrixMode(GL_TEXTURE);
      glScalef(10,1,1);
    glMatrixMode(GL_MODELVIEW);
    glxhuora(24, fd, fd, fd, 1, 1.0*x/640.0*8, 0.625*y/480.0*1, x, y, t*2, 0,1);  
    
  glpopad();
}



void george(float t, int swits, int swats) {
  int i;
  int kludge=GL_SPHERE_MAP;
  if (swats==0) {
    glPushAttrib(GL_ALL_ATTRIB_BITS);
    glTexGeniv(GL_S, GL_TEXTURE_GEN_MODE, &kludge);
    glTexGeniv(GL_T, GL_TEXTURE_GEN_MODE, &kludge);
    glEnable(GL_TEXTURE_GEN_S);
    glEnable(GL_TEXTURE_GEN_T);
    glMatrixMode(GL_TEXTURE);
    glPushMatrix();
    glTranslatef(0, t*8, 0);
    glMatrixMode(GL_MODELVIEW);
    glBindTexture(GL_TEXTURE_2D, 9);
    glColor4f(1, 1.0, 1.0, 1.0);
  } else {
    glPushAttrib(GL_ALL_ATTRIB_BITS);
    glBindTexture(GL_TEXTURE_2D, 2);
    glColor4f(1, 1.0, 1.0, 1.0);
  }
  glPushMatrix();  
  if (swits==1) {
    gluLookAt(0, -2.75*cos(t*2), -2.75*sin(t*2), 2*sin(t*1.32), 0, 1, 0, 1, 0);
  } else if (swits==2) {
    glTranslatef(0, -2*(sin(t*1.1354634)+.5)+((t-9)*(t-9)*20), 0);
    glScalef(0.5, 0.5, 0.5);
  } else if (swits==3) {
    glScalef(0.5, 0.5, 0.5);
  } else if (swits==4) {

    glPushAttrib(GL_ALL_ATTRIB_BITS);
    glDisable(GL_LIGHTING);
    glDisable(GL_DEPTH_TEST);
    glDisable(GL_NORMALIZE);
    glEnable(GL_BLEND);
    gluLookAt(0, -2.75*cos(t*2), -2.75*sin(t*2), 2*sin(t*1.32), 0, 1, 0, 1, 0);
    glPushMatrix();
      glColor4f(1, 1, 1, 1);
      glBindTexture(GL_TEXTURE_2D, 19);
      glRotatef(15*sin(t*7.32),0,1,0);
      glRotatef(25*cos(t*5),1,0,0);
      glRotatef(90*t*1.3, 1, 0, 0);
      glRotatef(90*t*2, 0, 1, 0);
      member_render(boel);
    glPopMatrix();
    glPopAttrib();
  } else if (swits==5) {
    gluLookAt(cos(t*1.456465), sin(t*1.1354634)+.5, sin(t*1.945245), 0, 0, 0, 0, 0, 1);
    glTranslatef(0, -2*(sin(t*1.1354634)+.5), 0);
    glScalef(0.5, 0.5, 0.5);
  } else {
    glTranslatef(0, -2*(sin(t*1.1354634)+.5), 0);
    glScalef(0.5, 0.5, 0.5);
  }

  glPushMatrix();
    glScalef(1.2, 1.2, 1.2);
    if (swits==3) {
      glTranslatef(0, 20*sin(t), 0);
      glRotatef(t*90, 0, 4, 0);
    } else {
      glRotatef(t*422.5, 0, 1, 0);
      glRotatef(t*190, 1, 0, 0);
      glRotatef(t*90, 0, 4, 0);
    }
    if (swats==0) member_render(tori1);
    else member_render(tori2);
  glPopMatrix();

  glPushMatrix();
    glScalef(1.1, 1.1, 1.1);
    if (swits==3) {
      glTranslatef(0, -20*sin(t), 0);
      glRotatef(t*90, 0, -5, 0);
    } else {
      glRotatef(t*357.5, 0, -1, 0);
      glRotatef(t*70, 1, 0, 0);
      glRotatef(t*90, 0, -5, 0);
    }
    if (swats==0) member_render(tori1);
    else member_render(tori2);
  glPopMatrix();

  glPushMatrix();
    glScalef(1, 1, 1);
    if (swits==3) {
      glTranslatef(0, 10*cos(t*2), 0);
      glRotatef(t*90, 0, 6, 0);
    } else {
      glRotatef(t*280, 0, 1, 0);
      glRotatef(t*160, -1, 0, 0);
      glRotatef(t*90, 0, 6, 0);
    }
    if (swats==0) member_render(tori1);
    else member_render(tori2);
  glPopMatrix();

  glPopMatrix();

  if (swats==0) {
    glMatrixMode(GL_TEXTURE);
    glPopMatrix();
    glMatrixMode(GL_MODELVIEW);
  }
  glPopAttrib();
}
/*
void drawbiaatch(float t) {
  
}
*/
void biaach(float t) {
  int i;
  int kludge=GL_SPHERE_MAP;
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glTexGeniv(GL_S, GL_TEXTURE_GEN_MODE, &kludge);
  glTexGeniv(GL_T, GL_TEXTURE_GEN_MODE, &kludge);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
    glTranslatef(0.25*sin(t), -2*(sin(t*1.1354634)+.5), -0.6+0.35*sin(t));
    glTranslatef(0.5, 0, 0.2);
    glScalef(5, 5, 5);
    glRotatef(30*sin(t), 0, 1, 0);
    glRotatef(180, 0, 1, 0);
    glRotatef(40, 1, 0, 0);

    glBindTexture(GL_TEXTURE_2D, 9);
    glColor4f(1, 1, 1, 1);
    member_render(eukko);

    glBindTexture(GL_TEXTURE_2D, 19);
    glEnable(GL_TEXTURE_GEN_S);
    glEnable(GL_TEXTURE_GEN_T);
    glEnable(GL_BLEND);
    glBlendFunc(GL_ONE, GL_ONE);//_MINUS_SRC_ALPHA);
    glColor4f(1, 1, 1, 0);
    glMatrixMode(GL_TEXTURE);
    glPushMatrix();
    glTranslatef(0, t*16, 0);
    member_render(eukko);
    glPopMatrix();
    glMatrixMode(GL_MODELVIEW);

  glPopMatrix();
  glPopAttrib();
}

void glSurge(float t) {
  int i;
  int kludge=GL_SPHERE_MAP;
  glpushad();
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glTexGeniv(GL_S, GL_TEXTURE_GEN_MODE, &kludge);
  glTexGeniv(GL_T, GL_TEXTURE_GEN_MODE, &kludge);
  glEnable(GL_TEXTURE_GEN_S);
  glEnable(GL_TEXTURE_GEN_T);
  glMatrixMode(GL_TEXTURE);
  glPushMatrix();
  glTranslatef(t*4, 0, 0);
  glMatrixMode(GL_MODELVIEW);
  glBindTexture(GL_TEXTURE_2D, 1);
  glColor4f(1, 1.0, 1.0, 1.0);
  gluLookAt(0, 0, -4, 0, 0, 0, 0, 1, 0);
  glPushMatrix();
//    glScalef(1+0.2*(1-fmod(t*16, 1)), 1+0.2*(1-fmod(t*16, 1)), 1+0.2*(1-fmod(t*16, 1)));
//    glRotatef(20*(1-fmod(t*16, 1)), 0, 1, 0);
    glRotatef(-270*t*4, 0, 1, 0);
    glScalef(2,2,1);
    glScalef(1.005, 1.175, 1);
    glTranslatef(0.1, 0.1125, 0);
    glRotatef(180, 0, 1, 0);
    glRotatef(90, 1, 0, 0);
    member_render(surge);
  glPopMatrix();

  glMatrixMode(GL_TEXTURE);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);

  glPopAttrib();
  glpopad();
}

float spang (float x) {
  return sin(x+sin(x)*.5);
//  return sin(x+sin(x));
}
float spong (float x) {
  return spang(x+spang(x)*.5);
}
float spung (float x) {
  return spong(x+spong(x)*.5);
}
float speng (float x) {
  return spung(x+spung(x)*.5);
}

void alkulaeppae (Space *s, float t, int mode) {
  int i;
  float fade;
  float move;
  float fade2;
  int kludge=GL_SPHERE_MAP;


  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_NORMALIZE);
  glEnable(GL_BLEND);

  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glTexGeniv(GL_S, GL_TEXTURE_GEN_MODE, &kludge);
  glTexGeniv(GL_T, GL_TEXTURE_GEN_MODE, &kludge);
  glEnable(GL_TEXTURE_GEN_S);
  glEnable(GL_TEXTURE_GEN_T);
  glMatrixMode(GL_TEXTURE);
  glPushMatrix();
//  glTranslatef(0, 0, t*16);
  glMatrixMode(GL_MODELVIEW);
  move=(1-spong((t*8+0.25)*3.1415926));
  fade=speng((t*8+0.25)*3.1415926);
  fade2=(1-fmod(t*4,1));
  fade2=fade2*fade2;
  gluLookAt(0, 0, -2.5, 0, 0, 1, 0, 1, 0);

  if(mode==0) {
    glPushMatrix();
    if((int)(t*4)==0) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "prepare", .25);
    } else if((int)(t*4)==1) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "for", .25);
    } else if((int)(t*4)==2) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "the", .25);
    } else if((int)(t*4)==3) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "clubbing", .25);
    } else if((int)(t*4)==4) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "experience", .25);
    } else if((int)(t*4)==5) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "of", .25);
    } else if((int)(t*4)==6) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "your", .25);
    } else if((int)(t*4)==7) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "life", .25);
    } else if((int)(t*4)==8) {
//      tekti=demogroup(s, "");
//      maketext((Group*)tekti, (Group*)corba, "towards", .25);
    } else if((int)(t*4)==9) {
//      tekti=demogroup(s, "");
//      maketext((Group*)tekti, (Group*)corba, "flying", 1);
    } else if((int)(t*4)==10) {
//      tekti=demogroup(s, "");
//      maketext((Group*)tekti, (Group*)corba, "the", 1);
    } else if((int)(t*4)==12) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "the", .25);
    } else if((int)(t*4)==13) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "surge", .25);
    } else if((int)(t*4)==14) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "is", .25);
    } else if((int)(t*4)==15) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "coming", .25);
/*    } else if((int)(t*4)==15) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "now", .25);*/
    } else {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "stupiiid", 1);
    }
    if((int)(t*4)==8||(int)(t*4)==9||(int)(t*4)==10||(int)(t*4)==11) {
      glColor4f(0, 0, 0, 0);
    } else {
      glColor4f(fade2, fade2, fade2, fade2);
    }
    glBindTexture(GL_TEXTURE_2D, 1);
    glRotatef(-(20-60*fmod(t*4,1)),0,1,0);
    glScalef(0.5,0.5,0.05+fade2);
    glTranslatef(0,0,0);
    member_render(tekti);
    glPopMatrix();
  }
  glColor4f(fade, fade, fade, fade);
  glBindTexture(GL_TEXTURE_2D, 19);

  glPushMatrix();
    glRotatef(15*sin(t*7.32),0,1,0);
    glRotatef(25*cos(t*5),1,0,0);
    glTranslatef(0, 0, move*64);//3-2.75*(1-fmod(t*4,1)));
    glRotatef(90*t*1.3, 1, 0, 0);
    glRotatef(90*t*2, 0, 1, 0);
    member_render(boel);
  glPopMatrix();

  glMatrixMode(GL_TEXTURE);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);

  glPopAttrib();

}


void kriitsit (Space *s, float t, int mode) {
  int i;
  float fade;
  float move;
  float fade2;
  int kludge=GL_SPHERE_MAP;


  view3d(0.5,0,1);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_NORMALIZE);
  glEnable(GL_BLEND);

  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glTexGeniv(GL_S, GL_TEXTURE_GEN_MODE, &kludge);
  glTexGeniv(GL_T, GL_TEXTURE_GEN_MODE, &kludge);
  glEnable(GL_TEXTURE_GEN_S);
  glEnable(GL_TEXTURE_GEN_T);
  glMatrixMode(GL_TEXTURE);
  glPushMatrix();
  glMatrixMode(GL_MODELVIEW);
  move=(1-spong((t*8+0.25)*3.1415926));
  fade=speng((t*8+0.25)*3.1415926);
  fade2=(1-fmod(t*4,1));
  fade2=fade2*fade2;
  gluLookAt(0, 0, -2.5, 0, 0, 1, 0, 1, 0);

  if(mode==0) {
    glPushMatrix();
    if((int)(t*4)==0) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "kooma", .25);
    } else if((int)(t*4)==1) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "haujobb", .25);
    } else if((int)(t*4)==2) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "farb rausch", .25);
    } else if((int)(t*4)==3) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "spinning kids", .25);
    } else if((int)(t*4)==4) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "kewlers", .25);
    } else if((int)(t*4)==5) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "komplex", .25);
    } else if((int)(t*4)==6) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "damage", .25);
    } else if((int)(t*4)==7) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "damones", .25);
    } else if((int)(t*4)==8) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "unique", .25);
    } else if((int)(t*4)==9) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "retro ac", .25);
    } else if((int)(t*4)==10) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "calodox", .25);
    } else if((int)(t*4)==11) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "phn", .25);
    } else if((int)(t*4)==12) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "exceed", .25);
    } else if((int)(t*4)==13) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "mass", .25);
    } else if((int)(t*4)==14) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "and", .25);
    } else if((int)(t*4)==15) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "you", .25);
/*    } else if((int)(t*4)==15) {
      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "now", .25);*/
    } else {
/*      tekti=demogroup(s, "");
      maketext((Group*)tekti, (Group*)corba, "stupiiid", 1);*/
    }
    glColor4f(fade2, fade2, fade2, fade2);
    glBindTexture(GL_TEXTURE_2D, 1);
    glRotatef(-(20-60*fmod(t*4,1)),0,1,0);
    glScalef(0.5,0.5,0.05+fade2);
    glTranslatef(0,0,0);
    member_render(tekti);
    glPopMatrix();
  }

  glMatrixMode(GL_TEXTURE);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);

  glPopAttrib();

}


void spboom(float *pos, float t, float t2, float *par) {
  float fromdir[3]={ par[0], par[1], par[2] };
  float todir[3]={ par[3], par[4], par[5] };
  float radius=par[6];
/*
  pos[0]=par[0]+cos(t); 
  pos[1]=par[1]+sin(t);
  pos[2]=par[2]-tan(par[0]*0.1);
*/
  float k1=(exp((.5-t)*4)-radius)*.1, k2=(exp((t-.5)*4)-radius)*.1;

  float fop;
  fop=pow(t2,24);

  pos[0]=fromdir[0]*k1+todir[0]*k2;
  pos[1]=fromdir[1]*k1+todir[1]*k2;
  pos[2]=fromdir[2]*k1+todir[2]*k2;
  pos[3]=.0005;
//  if (t2>.7) {
    pos[4]=par[7]*t2+fop;
    pos[5]=par[8]*t2+fop;
    pos[6]=par[9]*t2+fop;
    pos[7]=0;//par[10]*t2+fop;
/*  } else {
    pos[5]*=.1;
  }*/
}

void spboom2(float *pos, float t, float t2, float *par) {
  float fromdir[3]={ par[0]*0.1, par[1], par[2] };
  float todir[3]={ par[3], par[4]*0.1, par[5]*0.1 };
  float radius=par[6];
  float k1=(exp((.5-t)*4)-radius)*.1, k2=(exp((t-.5)*4)-radius)*.1;

  float fop;
  fop=pow(t2,24);

  pos[0]=fromdir[0]*k1+todir[0]*k2;
  pos[1]=fromdir[1]*k1+todir[1]*k2;
  pos[2]=fromdir[2]*k1+todir[2]*k2;
  pos[3]=.0005;

  pos[4]=par[7]*t2+fop;
  pos[5]=par[8]*t2+fop;
  pos[6]=par[9]*t2+fop;
  pos[7]=0;//par[10]*t2+fop;

}

void sparkle(float t) {
  int i;
  float tx;
  float bri;
  static float rands[4*1000];
  float move;
  float fade;
  if (rands[0]==0) {
    for (i=0; i<4*1000; i++) rands[i]=0.5-rand()*(1./RAND_MAX);
  }
  fade=spung((t*8+0.25)*3.1415926);

  tx=fmod(t*4,1);
  bri=fade;
  glpushad();
  view3d(.5, 0, 1);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_COLOR_MATERIAL);
  glDisable(GL_LIGHTING);
  gluLookAt(0, 0, -0.2, 0, 0, 0, 0, 1, 0);
  for(i=0;i<20;i++) {
    float x;
    float y;
    float z;
    float par[11];
    par[0]=rands[i*4];
    par[1]=rands[i*4+1];
    par[2]=rands[i*4+2];
    par[3]=rands[(int)((par[2]+1)*200)];
    par[4]=rands[(int)((par[0]+1)*200)];
    par[5]=rands[(int)((par[1]+1)*200)];
    par[6]=1.5+rands[i*3];
    par[7]=(1-tx)*0.125+0.125*bri;
    par[8]=(1-tx)*0.25+0.25*bri;
    par[9]=(1-tx)*0.5+0.5*bri;
    par[10]=bri;


//    glColor4f((1-tx)*0.125+0.125*bri, (1-tx)*0.25+0.25*bri, (1-tx)*0.5+0.5*bri, bri);
//    glColor4f(1, 1-i*0.05, 1-i*0.1, 1);

    glRotatef(45*(t+i*0.1),0,0,par[0]);
    glRotatef(45*cos(t+i*0.1),par[2],0,0);
    glRotatef(45*sin(t+i*0.1),0,par[1],0);

    makevip2(kvirr, 5, 3, tx+i*0.025, 0.2, 0, spboom, par);
    member_render(kvirr);
  }
  glpopad();
}

void sparkle2(float t) {
  int i;
  float tx;
  float bri;
  static float rands[4*1000];
  float move;
  float fade;
  if (rands[0]==0) {
    for (i=0; i<4*1000; i++) rands[i]=0.5-rand()*(1./RAND_MAX);
  }
  fade=spung((t*2+0.25)*3.1415926);

  tx=0.5+0.5*sin(t);
  bri=fade;
//  glpushad();
//  view3d(.5, 0, 1);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_COLOR_MATERIAL);
  glDisable(GL_LIGHTING);
//  gluLookAt(0, 0, -0.2, 0, 0, 0, 0, 1, 0);
  for(i=0;i<20;i++) {
    float x;
    float y;
    float z;
    float par[11];
    par[0]=rands[i*4];
    par[1]=rands[i*4+1];
    par[2]=rands[i*4+2];
    par[3]=rands[(int)((par[2]+1)*200)];
    par[4]=rands[(int)((par[0]+1)*200)];
    par[5]=rands[(int)((par[1]+1)*200)];
    par[6]=1.5+rands[i*3];
    par[7]=(1-tx)*0.125+0.125*bri;
    par[8]=(1-tx)*0.25+0.25*bri;
    par[9]=(1-tx)*0.5+0.5*bri;
    par[10]=bri;


//    glColor4f((1-tx)*0.125+0.125*bri, (1-tx)*0.25+0.25*bri, (1-tx)*0.5+0.5*bri, bri);
//    glColor4f(1, 1-i*0.05, 1-i*0.1, 1);

    glRotatef(45*(t+i*0.1),0,0,par[0]);
    glRotatef(45*cos(t+i*0.1),par[2],0,0);
    glRotatef(45*sin(t+i*0.1),0,par[1],0);

    makevip2(kvirr, 5, 3, tx+i*0.025, 0.2, 0, spboom2, par);
    member_render(kvirr);
  }
//  glpopad();
}

void cam1 (float t) {
//  gluLookAt(5.5*sin(t*3.14), 1.8+0.02*sin(t*1.0654334), 24, 5.5*sin(t*3.14*0.75), 1.8+0.02*sin(t*1.054), 0, 0, 1, 0);
  gluLookAt(5.5*sin(t*3.14*0.5), 1.2+0.2*sin(t*1.0654334), 24.75, 
            5.5*sin(t*3.14*0.45), 1.4+0.02*sin(t*1.054), 20, 
            0, 1, 0);
}
void cam2 (float t) {
  gluLookAt(5.5, 1.8+0.052*sin(t*1.0654334), -26*sin(t*0.5), 
            5.5, 1.8+0.2*sin(t*1.054), -18*sin(t*0.5), 
            sin(t*3.141*0.5), 1, 0);
}
void cam3 (float t) {
  gluLookAt(3*sin(t), 1.4+0.5*sin(t*1.0654334), 3*cos(t*1.2345345), 
            0, 2.8, 0, 
            0, 1, 0);
}
void cam4 (float t) {
  gluLookAt(0, 5.8+0.52*sin(t*1.0654334), 26*sin(t*3.141*0.5), 
            0, 5.8+0.2*sin(t*1.054), -18*sin(t*3.141*0.5), 
            sin(t*3.141*0.5), 1, 0);
}
void cam5 (float t) {
  gluLookAt(3*sin(t), 1.4+sin(t*1.654334), -5+cos(t*1.6345345), 
            0, 3.8, -8, 
            0, 1, 0);
}
void cam6 (float t) {
  gluLookAt(sin(t), 1.4+sin(t*1.0654334), cos(t*1.4345345), 
            15*sin(t), 5.8, -24, 
            0, 1, 0);
}
void cam7 (float t) {
  gluLookAt(sin(t), 1.4+sin(t*1.0654334), cos(t*1.2345345), 
            0, 3.8, 0, 
            0, 1, 0);
}
void cam8 (float t) {
  gluLookAt(1.5*sin(t), 1.8+0.02*sin(t*1.0654334), 0, 
            2*sin(t*3.14), 2.8+0.72*sin(t*1.054), -26, 
            0, 1, 0);
}
void cam9 (float t) {
  gluLookAt(2.5*sin(t*0.65), 7.2-0.72*sin(t*3.141*0.5), -19.5+sin(t*3.14), 
            2.5*cos(t*3.141*0.5), 10.8-0.52*sin(t*1.054*3.14*0.5), -28, 
            0, 1, 0);
}

void camrand(float t, int rate) {
  if((int)(fmod(t,1)*rate)%8==0) {
    cam1(t);
  } else if((int)(fmod(t,1)*rate)%8==1) {
    cam2(t);
  } else if((int)(fmod(t,1)*rate)%8==2) {
    cam3(t);
  } else if((int)(fmod(t,1)*rate)%8==3) {
    cam4(t);
  } else if((int)(fmod(t,1)*rate)%8==4) {
    cam5(t);
  } else if((int)(fmod(t,1)*rate)%8==5) {
    cam6(t);
  } else if((int)(fmod(t,1)*rate)%8==6) {
    cam7(t);
  } else if((int)(fmod(t,1)*rate)%8==7) {
    cam8(t);
  } else {
    cam1(t);
  }
}

void kirgcam(float t) {
  int row=fmod(t,1)*128;
  if (t>=12 && t<13) { 
    cam3(t);
  } else if (t>=13 && t<14) { 
    cam2(t);
  } else if (t>=14 && t<15) { 
    camrand(t,2);
  } else if (t>=15 && t<16) { 
    if (row<112) {
      camrand(t,2);
    } else {
      cam8(t);
    }
  //PKUVIO MESSIIN TSS
  } else if (t>=16 && t<17) { 
    camrand(t,4);
  } else if (t>=17 && t<18) { 
    camrand(t,4);
  //sit nousee
  } else if (t>=18 && t<19) { 
    camrand(t,4);
  } else if (t>=19 && t<20) { 
    if(row<96) {
      camrand(t,8);
    } else if(row>=96&&row<112){
      camrand(t,16);
    } else {
      camrand(t,64);
    }
  } else {cam1(t);}
}


void kirgisia_x(float t) {
  static float pos[4] = {0, 6.0, 10, 1.0};
  float brb;

  view3d(.5, 0, 1);
  glColor4f(5,5,5,1);
  glDisable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
//  gluLookAt(5.5, 1.8+0.02*sin(t*1.0654334), 24*sin(t*0.5), 0, 1.8+0.02*sin(t*1.054), 24*sin(t*0.5), 0, 1, 0);

  if(t>=20&&t<25) {
    cam9(t);
  } else {
    kirgcam(t);
  }
  glLightfv(GL_LIGHT0, GL_POSITION, pos);
//  member_render(member_find(syrka, "segment_01"));
  { 
    static int cnt; 
//    if ((cnt++&15)==0) demodesign_doradio(member_find(syrka, "latti"), syrka, 1);

  glBindTexture(GL_TEXTURE_2D, 20);
    member_render(member_find(syrka, "latti"));
  glBindTexture(GL_TEXTURE_2D, 28);
    member_render(member_find(syrka, "sein"));
  glBindTexture(GL_TEXTURE_2D, 28);
    member_render(member_find(syrka, "ptolp"));
  glBindTexture(GL_TEXTURE_2D, 28);
    member_render(member_find(syrka, "kaar"));
  glBindTexture(GL_TEXTURE_2D, 28);
    member_render(member_find(syrka, "ktolp"));
  glBindTexture(GL_TEXTURE_2D, 25);
    member_render(member_find(syrka, "paat"));
  glBindTexture(GL_TEXTURE_2D, 26);
    member_render(member_find(syrka, "kattok"));
  glBindTexture(GL_TEXTURE_2D, 27);
    member_render(member_find(syrka, "kupo"));
  glBindTexture(GL_TEXTURE_2D, 29);
    member_render(member_find(syrka, "ikkun"));
  glBindTexture(GL_TEXTURE_2D, 29);
    member_render(member_find(syrka, "iko"));
  }
}

void kirgisia(float t) {
  float brb;

  glpushad();
  texbegin(128, 128);
  kirgisia_x(t);
  texend(30);
  brb=(0.5+0.5*sin(t*3.141))*0.5;
  texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
  kirgisia_x(t);
  glhuora(30, brb, brb, brb, 1-brb, 1, -0.667, 1);
  glpopad();

}






void raveta(Space *s, float t) {
  float r=fmod(t, 1);
  float rs=128;
  float row=r*rs;
  int pat=(int)(t);
  if (fmod(((int)(r*8)), 8)==0) {
    if(t>=20&&t<20.125) {
      alkulaeppae(s,t,1);
      if(fmod(t*4,1)<0.25) {
        glRadial2(19, 5, (1-fmod(t*4,1)), (1-(fmod(t*16,1)))*0.05, 1, 1);
      }
      sparkle(t);
      glImgStrobe(1, (t*4-((int)(t*4)))/4, 2, 2);
      numedia(t);
    } else {
      kirgisia(t);
      alkulaeppae(s,t,1);
      if(fmod(t*4,1)<0.25) {
        glRadial2(19, 5, (1-fmod(t*4,1)), (1-(fmod(t*16,1)))*0.05, 1, 1);
      }
      sparkle(t);
    }
  } else if (fmod(((int)(r*8)), 8)==1) {
    tunel(t);
    george(t, 0, 0);
    numedia(t);
  } else if (fmod(((int)(r*8)), 8)==2) {
    tunel2(t, 2, 0.5+0.5*sin(r*3.141*8), pat, row);
    biaach(t);
    numedia(t);
  } else if (fmod(((int)(r*8)), 8)==3) {
    tunel(t);
    alkulaeppae(s,t,1);
    if(fmod(t*4,1)<0.25) {
      glRadial2(19, 5, (1-fmod(t*4,1)), (1-(fmod(t*16,1)))*0.05, 1, 1);
    }
    numedia(t);
  } else if (fmod(((int)(r*8)), 8)==4) {
    kirgisia(t);
    alkulaeppae(s,t,1);
    if(fmod(t*4,1)<0.25) {
      glRadial2(19, 5, (1-fmod(t*4,1)), (1-(fmod(t*16,1)))*0.05, 1, 1);
    }
    sparkle(t);
  } else if (fmod(((int)(r*8)), 8)==5) {
    george(t, 4, 0);
    sparkle(t);
    numedia(t);
  } else if (fmod(((int)(r*8)), 8)==6) {
    tunel2(t, 2,  0.5+0.5*sin(r*3.141*8), pat, row);
    biaach(t);
    numedia(t);
  } else if (fmod(((int)(r*8)), 8)==7) {
    george(t, 4, 0);
    alkulaeppae(s,t,1);
    if(fmod(t*4,1)<0.25) {
      glRadial2(19, 5, (1-fmod(t*4,1)), (1-(fmod(t*16,1)))*0.05, 1, 1);
    }
    numedia(t);
  }
  glImgStrobe(2, (t*4-((int)(t*4)))/4, 1, 1);
}



void ankkapart(float t, int fno) {
  static char buf[320*240];
  float k;//=(sin(t*2.86578655)+sin(t*4.54325)+sin(t*5.6752)+sin(t*7.2342))*.125+.5;
  getframe(buf, 320, anki, 320, 240, fno);

//  k=pow(k,.3);
  k=1;
  glpushad();
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  view2d(.5, 0);
  glBindTexture(GL_TEXTURE_2D, 32);
  glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 320, 240, GL_LUMINANCE, GL_UNSIGNED_BYTE, buf);
//  glFinish(); //FUSK! is this really needed?
  
  glDisable(GL_LIGHTING);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND); 
  glDisable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_ONE, GL_ONE);  
  glPushMatrix();
    glTranslatef(0.0295*sin(t*31.523),0,0);
    glColor4f(k,0,0,1);
    glBegin(GL_QUAD_STRIP);
    glTexCoord2f(0, 240/256.); glVertex2f(-1, 1);
    glTexCoord2f(0, 0); glVertex2f(-1, -1);
    glTexCoord2f(320/512., 240/256.); glVertex2f(1, 1);
    glTexCoord2f(320/512., 0); glVertex2f(1, -1);
    glEnd();
  glPopMatrix();
  glPushMatrix();
    glTranslatef(0,0.035*sin(t*28.52375),0);
    glColor4f(0,k,0,1);
    glBegin(GL_QUAD_STRIP);
    glTexCoord2f(0, 240/256.); glVertex2f(-1, 1);
    glTexCoord2f(0, 0); glVertex2f(-1, -1);
    glTexCoord2f(320/512., 240/256.); glVertex2f(1, 1);
    glTexCoord2f(320/512., 0); glVertex2f(1, -1);
    glEnd();
  glPopMatrix();
  glPushMatrix();
    glColor4f(0,0,k,1);
    glBegin(GL_QUAD_STRIP);
    glTexCoord2f(0, 240/256.); glVertex2f(-1, 1);
    glTexCoord2f(0, 0); glVertex2f(-1, -1);
    glTexCoord2f(320/512., 240/256.); glVertex2f(1, 1);
    glTexCoord2f(320/512., 0); glVertex2f(1, -1);
    glEnd();
  glPopMatrix();
  glpopad();
}





void dissaus(Space *s, float t) {
//  static float pos[4] = {5.0, 5.0, 400.0, 1.0};
  static float pos[4] = {0.5, 2.0, 0.75, 1.0};
  float rs=128;
  float r=fmod(t, 1);
  float row=r*rs;
  int pat=(int)(t);
  int i, j, k;
  float boe=(24.0+((8*5+2 )/128.0));//vaihdon paikka
  float brb;

/***BACKGROUND TEXTURES***/


  //PT 1
  if (pat>=0 && pat<1) {

    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 0.5, 2);
    }

    if (row>=0 && row<4) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=124 && row<126) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
//      glRadial(1, 7, 1.25, 1/(fmod(t*16, 1)), sin(t*3), cos(t*2));
    } else {
      numedia(t);
//      glhuora(1, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
    }
//    kiksublob(t, t, t*20, 0.5+1*sin(r), 20, -1);

  //PT 2
  } else if (pat>=1 && pat<2) {

    if (row>=0 && row<4) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=60 && row<62) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=64 && row<66) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=112 && row<114) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=116 && row<118) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else {
      numedia(t);
//      glhuora(1, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
//      kiksublob(t, 1, 1, 1.12, 10+1*sin(t*7.89275)+1*cos(t*5.3394), -0.75);
    }

  //PT 3
  } else if (pat>=2 && pat<3) {

    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 0.5, 2);
    }

    if (row>=0 && row<4) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=60 && row<62) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=64 && row<66) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=112 && row<114) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=124 && row<126) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else {
      numedia(t);
//      glhuora(2, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
//      kiksublob(t, 1, 1, 1.12, 10+1*sin(t*7.89275)+1*cos(t*5.3394), -0.75);
    }

  //PT 4
  } else if (pat>=3 && pat<4) {

    if (row>=0 && row<4) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=48 && row<50) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=60 && row<62) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=64 && row<66) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=96 && row<98) {
      tunel(t);
      george(t, 0, 0);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else {
      if(row<96) {
        numedia(t);
      }
//      kiksublob(t, 1, 1, 1.12, 10+1*sin(t*7.89275)+1*cos(t*5.3394), -0.75);
//      glhuora(2, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
    }

  //YO Synkit kuosissa...

  //PT 5, uppaa alkaa
  } else if (pat>=4 && pat<5) {

    brb=(t-4)*0.5;

    texbegin(128, 128);
      george(t, 5, 0);
    texend(30);
    texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
    view3d(0.5,0,1);


    if (row>=0 && row<4) {
      tunel(t);
      george(t, 0, 1);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else {
//      glhuora(4, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
      tunel(t);
      george(t, 0, 0);
      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);

      surgetxt(t);
    }

    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 1, 2);
    }

  //PT 6
  } else if (pat>=5 && pat<6) {

    brb=0.5+((t-5)*0.5);

    texbegin(128, 128);
      george(t, 5, 0);
    texend(30);
    texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
    view3d(0.5,0,1);

    if (row>=116 && row<118) {
      glSurge(t);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else if (row>=120 && row<122) {
      glSurge(t);
      glRadial(0, 2, 1.25, 1, 1, 1);
    } else {
//      glhuora(4, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
      tunel(t);
      george(t, 0, 0);
      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);
    }
    surgetxt(t);

  //PT 7
  } else if (pat>=6 && pat<7) {

    brb=(fmod(t*64+0,1)+fmod(t*64+2,1)+fmod(t*64+4,1));

    texbegin(128, 128);
      george(t, 5, 0);
    texend(30);
    texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
    view3d(0.5,0,1);

    if (row>=0 && row<1) {
      tunel(t);
      george(t, 0, 1);
      glSurge(t);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=2 && row<3) {
      tunel(t);
      george(t, 0, 1);
      glSurge(t);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=4 && row<5) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=6 && row<7) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else {
//      glhuora(6, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
      tunel(t);
      george(t, 0, 0);
      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);
//      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);
    }

    surgetxt(t);
    numedia2(t);
    if (row>=0 && row<64) {
       glKredut(10, r-0, 2);
    }

  //PT 8
  } else if (pat>=7 && pat<8) {

    brb=(fmod(t*64+0,1)+fmod(t*64+2,1)+fmod(t*64+4,1));

    texbegin(128, 128);
      george(t, 5, 0);
    texend(30);
    texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
    view3d(0.5,0,1);

    if (row>=0 && row<1) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=2 && row<3) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=4 && row<5) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=6 && row<7) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else {
//      glhuora(6, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
      tunel(t);
      george(t, 0, 0);
      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);
    }

    surgetxt(t);
    numedia2(t);
    if (row>=0 && row<64) {
       glKredut(11, r-0, 2);
    }

    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 0.5, 2);
    }

  //YO synkit ok

  //PT 9
  } else if (pat>=8 && pat<9) { 

    brb=(1-(t-8)*0.5)*(fmod(t*64+0,1)+fmod(t*64+2,1)+fmod(t*64+4,1));

    texbegin(128, 128);
      george(t, 5, 0);
    texend(30);
    texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
    view3d(0.5,0,1);


    if (row>=0 && row<1) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=2 && row<3) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=4 && row<5) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=6 && row<7) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=64 && row<65) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=66 && row<67) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=68 && row<69) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=70 && row<71) {
      tunel(t);
      george(t, 0, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else {
//      glhuora(6, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
      tunel2(t, 2-r*0.5, r*0.5, pat, row);
      george(t, 0, 0);
      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);
    }

    if (row>=0 && row<64) {
       glKredut(12, r-0, 2);
    }
    if (row>=64 && row<128) {
      glKredut(13, r-0.5, 2);
    }
    numedia2(t);

    if (row>=0 && row<16) {
      if(row>=0&&row<2) {
        glSurge(t);
      }
      glImgStrobe(2, r-0, 0.5, 2);
    }

  //PT 10
  } else if (pat>=9 && pat<10) { 

    brb=(0.5-(t-9)*0.5)*(fmod(t*64+0,1)+fmod(t*64+2,1)+fmod(t*64+4,1));

    texbegin(128, 128);
      george(t, 5, 0);
    texend(30);
    texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
    view3d(0.5,0,1);

    tunel2(t, 1.5-(r*0.5), 0.5+r*0.5, pat, row);

    if (row>=0 && row<1) {
      george(t, 2, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=2 && row<3) {
      george(t, 2, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=4 && row<5) {
      george(t, 2, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=6 && row<7) {
      george(t, 2, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=64 && row<65) {
      george(t, 2, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=66 && row<67) {
      george(t, 2, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=68 && row<69) {
      george(t, 2, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=70 && row<71) {
      george(t, 2, 1);
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else {
//      glhuora(6, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
      george(t, 2, 0);
      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);
    }
    numedia2(t);


    if (row>=0 && row<64) {
       glKredut(14, r-0, 2);
    }
    if (row>=64 && row<128) {
      glKredut(15, r-0.5, 2);
    }

    if (row>=86 && row<128) {
      glSnareBuild(3, r-0, r*r, 4, 2);
    }

  //PT 11
  } else if (pat>=10 && pat<11) { 

    brb=(t-10)*0.5;

    texbegin(128, 128);
      george(t, 5, 0);
    texend(30);
    texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
    view3d(0.5,0,1);
/*
    if (row>=0 && row<1) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=2 && row<3) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=4 && row<5) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=6 && row<7) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=64 && row<65) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=66 && row<67) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=68 && row<69) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=70 && row<71) {
      glRadial(2, 2, 1.25, 1, 1, 1);

    } else {*/
//      glhuora(6, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
      tunel2(t, 1.5, 1, pat, row);
      biaach(t);
      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);
//      george(t, 3, 1);
//    }

    if (row>=46 && row<47||row>=48 && row<49||row>=52 && row<53||row>=54 && row<55||row>=58 && row<59) {
      glRadial(7, 2, 1.25, 1, 1, 1);
    }

    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 0.5, 2);
    }

  //PT 12
  } else if (pat>=11 && pat<12) { 
    brb=(t-11)*0.5+0.5;

    texbegin(128, 128);
      george(t, 5, 0);
    texend(30);
    texblur(30, 128,128, 0,0,brb,brb,brb, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
    view3d(0.5,0,1);
    if(t>11.99) {
      texbegin(256, 256);
        tunel2(t, 1.5+r*0.5, 1, pat, row);
        biaach(t);
      texend(31);
      texblur(31, 256,256, 0,0,1,1,1, -1.5,0,1,1,1, 1.5,0,1,1,1, 0,1.5,1,1,1, 0,-1.5,1,1,1);
      view3d(0.5,0,1);
    }

/*
    if (row>=0 && row<1) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=2 && row<3) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=4 && row<5) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=6 && row<7) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=64 && row<65) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=66 && row<67) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=68 && row<69) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else if (row>=70 && row<71) {
      glRadial(2, 2, 1.25, 1, 1, 1);
    } else {*/
      tunel2(t, 1.5+r*0.5, 1, pat, row);
      biaach(t);
      glhuora(30, 1.0, 1.0, 1.0, 1.0, 1, -0.667, 0);

    if (row>=46 && row<47||row>=48 && row<49||row>=52 && row<53||row>=54 && row<55||row>=58 && row<59||
       row>=110 && row<111||row>=112 && row<113||row>=116 && row<117||row>=118 && row<119||row>=122 && row<123) {
      glRadial(7, 2, 1.25, 1, 1, 1);
    }

    if (row>=72 && row<112) {
      glSnareBuild(3, r-0, r*r, 4, 2);
    } else if (row>=112){
      glSnareBuild(3, r-0, r*r, 8, 4);
    }

  //SUVANTOOOH
  } else if (pat>=12 && pat<13) { 

    brb=(1-fmod(t*2,1));
    brb=brb*brb;
    kirgisia(t);
    if(row>=0&&row<64){
      glhuora(31, brb, brb, brb, 1.0, 1, -0.667, 0);
    }
    if (row>=0 && row<32) {
      glImgStrobe(2, r-0, 1.0, 3);
    }

  } else if (pat>=13 && pat<14) { 
    kirgisia(t);

  } else if (pat>=14 && pat<15) { 

    kirgisia(t);
    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 1.0, 2);
    }

  } else if (pat>=15 && pat<16) { 

    kirgisia(t);
    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 1.0, 2);
    }

    if (row>=64 && row<64+8) {
      glImgStrobe(2, r-(64/rs), 1.0, 1);
    }

    if (row>=96 && row<96+8) {
      glImgStrobe(2, r-(96/rs), 1.0, 1);
    }

    if (row>=112 && row<112+8) {
      glImgStrobe(2, r-(112/rs), 1.0, 1);
    }

    if (row<112) {
      glSnareBuild(3, r-0, r*r, 4, 2);
    } else if (row>=112){
      glSnareBuild(3, r-0, r*r, 8, 4);
    }



  //PKUVIO MESSIIN TSS
  } else if (pat>=16 && pat<17) { 

    kirgisia(t);
    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 1.0, 2);
    }
  } else if (pat>=17 && pat<18) { 

    kirgisia(t);
    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 1.0, 2);
    }

    if (row>=64 && row<128) {
      glSnareBuild(3, r-(96/rs), ((r-0.5)*(r-0.5)), 4, 2);
    }

  //sit nousee
  } else if (pat>=18 && pat<19) { 

    kirgisia(t);
    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 1.0, 2);
    }

    if (row>=64 && row<64+16) {
      glImgStrobe(2, r-(64/rs), 1.0, 2);
    }

    if (row>=124 && row<124+8) {
      glImgStrobe(2, r-(124/rs), 1.0, 1);
    }

    glSnareBuild(3, r, r*r*r*0.25, 4, 2);

  } else if (pat>=19 && pat<20) { 

    kirgisia(t);
    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 1.0, 2);
    }

    if (row>=32 && row<32+8) {
      glImgStrobe(2, r-(32/rs), 1.0, 1);
    }

    if (row>=64 && row<64+8) {
      glImgStrobe(2, r-(64/rs), 1.0, 1);
    }

    if (row>=80 && row<80+8) {
      glImgStrobe(2, r-(80/rs), 1.0, 1);
    }
    if (row>=96 && row<96+4) {
      glImgStrobe(2, r-(96/rs), 1.0, 0.5);
    }

    if (row>=104 && row<104+4) {
      glImgStrobe(2, r-(104/rs), 1.0, 0.5);
    }
    if (row>=112 && row<112+4) {
      glImgStrobe(2, r-(112/rs), 1.0, 0.5);
    }

    if (row>=112) {
      glSnareBuild(3, r-0, 0.25+(r*r*r*0.5), 8, 4);
    } else {
      glSnareBuild(3, r-0, 0.25+(r*r*r*0.5), 4, 2);
    }
    if (row>=96) {
      glSnareBuild(2, r-0, 0.5+(r*0.5), 4, 2);
    }

  //suvanto loppuu
  } else if (pat>=20 && pat<24) { 
    raveta(s,t);
    
    kriitsit(s,t-20,0);
 
    if (pat>=20 && pat<20) {
      if (row>=0 && row<16) {
        glImgStrobe(2, r-0, 1.0, 2);
      }
    }
    if (pat>=23 && pat<24) {
      if (row>=64 && row<129) {
        glSnareBuild(3, r-0, 0.25+(r*r*0.75), 4, 2);
      }
    }

  } else if (t>=24 && t<boe ) { 
    raveta(s,t);
    if (row>=0 && row<16) {
      glImgStrobe(2, r-0, 1.0, 2);
    }

  //PT N+1
  } else if (t>=boe&&t<(boe+25)) {
//    glhuora(8, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);
    glpushad();
    texbegin(128, 128);

    ankkapart(t,(t-boe)*(200/25.)*4096);

    texend(30);
    brb=(.5+0.5*sin(t*3.141))*0.5;
    texblur(30, 128,128, 0,0,.5,.5,.5, -1.5,0,brb,brb,brb, 1.5,0,brb,brb,brb, 0,1.5,brb,brb,brb, 0,-1.5,brb,brb,brb);
//    ankkapart(t,(t-boe)*(200/25.)*4096);
    {
      float k=pow(.5+0.5*sin(t*79.756756),.2);
      glhuora(30, k, k, k, 1, 1, -0.667, 1);
    }
    glpopad();
    if (t-boe>=0 && t-boe<16) {
      glImgStrobe(1, t-boe, 1.0, 2);
    }
    if (t-boe>=0 && t-boe<32) {
      glImgStrobe(25, t-boe, 1.0, 1);
    }
  } else {
  }

//  if (pat>=0 && pat<12||pat>=20 && pat<24.3) {
//    if (row>=0 && row<8) {
//      glImgStrobe(3, r-0, 1.0, 1);
//    } else if (row>=64 && row<72) {
//      glImgStrobe(3, r-(0+64/rs), 1.0, 1);
//    }
//  }

  if (pat>=8 && pat<12) {
    if (row>=22 && row<25) {
      glRadial(4, 7, 1.025, 1+1/(fmod((t*16+22), 1))*0.25, 1+0.2*sin(t*3), cos(t*2));
//      glRadial(4, 4, 1.25, 1, 1, 1);
    } else if (row>=28 && row<33) {
      glRadial(4, 7, 1.025, 1+1/(fmod((t*16+28), 1))*0.25, 1+0.2*sin(t*3), cos(t*2));
//      glRadial(4, 4, 1.25, 1, 1, 1);
    } else if (row>=86 && row<89) {
      glRadial(4, 7, 1.025, 1+1/(fmod((t*16+86), 1))*0.25, 1+0.2*sin(t*3), cos(t*2));
//      glRadial(4, 4, 1.25, 1, 1, 1);
    } else if (row>=92 && row<97) {
      glRadial(4, 7, 1.025, 1+1/(fmod((t*16+92), 1))*0.25, 1+0.2*sin(t*3), cos(t*2));
//      glRadial(4, 4, 1.25, 1, 1, 1);
    }
  }

//  glSnareBuild(4, r, 0.5+0.5*sin(r), 4, 2);



  if(pat>=0&&pat<4) {
    alkulaeppae(s,t,0);
    sparkle(t);
    if(fmod(t*4,1)<0.25) {
      glRadial2(19, 5, (1-fmod(t*4,1)), (1-(fmod(t*16,1)))*0.05, 1, 1);
    }
    glImgStrobe(2, (t*4-((int)(t*4)))/4, 1, 1);/**/
  }


//    tunel(t);

//  george(t, 1);
//  biaach(t);

//  glhuora(10, 1.0, 1.0, 1.0, 0, 1, 0.667, 0);

/*
  glDisable(GL_TEXTURE_2D);
  glEnable(GL_COLOR_MATERIAL);
*/


/*
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);

  effu();
*/ 
/*
  glpushad();
  view3d(.5, 0, 1);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_COLOR_MATERIAL);
  glDisable(GL_LIGHTING);
  glColor4f(1, 1, 1, 1);
  gluLookAt(0, 0, -3, 0, 0, 0, 0, 1, 0);
//  member_render(corba);
  makevip2(kvirr, 40, 3, t*16, 2, 0, vipfun);
  member_render(kvirr);
  makevip2(kvirr, 40, 3, t*16+4, 2, 0, vipfun);
  member_render(kvirr);
  makevip2(kvirr, 40, 3, t*16+8, 2, 0, vipfun);
  member_render(kvirr);
  glpopad();
*/  


/*
  gluLookAt(cos(t*1.456465)*5, sin(t*1.1354634)*5, sin(t*1.945245)*5, 0, 0, 0, 0, 1, 0);
  glScalef(.1, .1, .1);
  member_render(segis);
*/



  glLightfv(GL_LIGHT0, GL_POSITION, pos);
  glDisable(GL_LIGHTING);
/*
  {
  static int lkm=0;
  if ((lkm++&63)==0) demogroup_doradio(corn, 3);
  }

  gluLookAt(cos(t*1.456465)*1, sin(t*1.1354634)*1, sin(t*1.945245)*1, 0, 0, 0, 0, 1, 0);
  member_render(corn);
*/


/*glRotatef(sin(t)*360, 0.5, 1.0, 0);

  glTranslatef(0.86*sin(timmy*1), 1.1, 1.08);
  glRotatef(sin(timmy)*6, 2, 1.0, 0.13);
  glTranslatef(0.0, -0.5, 0.2);*/

/*  
  gluLookAt(cos(t*1.456465)*5, sin(t*1.1354634)*5, sin(t*1.945245)*5, 0, 0, 0, 0, 1, 0);
  glScalef(.1, .1, .1);
  member_render(esker);
*/

/*
  klimp=demodesign(s);
  makeblob(klimp, 20, 20);
  vobl(klimp, timmy*5, 0.5, 10);

  obju=demodesign(s);
  design_lue3ds(obju, "models/segment1.3ds", 1);
  design_calcnormals(obju);
  design_unitize(obju);
  vobl(obju, t*5, 0.05, 10);
*/

  
/*
  if (fmod(timmy*16, 1)>.5) {
    glhuora(1, .1, .1, .1, 1, 1, 1, 0, 0, 0);
    glhuora(2, .1, .1, .1, 1, 1.1, 1.1, 0, 0, 0);
    glhuora(3, .1, .1, .1, 1, 1.2, 1.2, 0, 0, 0);
  }
*/

}






void radiotest(Space *s, float t) {
  static float pos[4] = {0, 6.0, 10, 1.0};
  unsigned char *keys=SDL_GetKeyState(NULL);
  char buff[100];
  FILE *fp;
  static int pass=0;
  glpushad();
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_LIGHTING);
  view3d(.5, 0, .5);
  gluLookAt(.8*sin(t*0.8763),.5+.2*sin(t*0.6435),.8*cos(t*0.76835), .2*cos(t*0.57674),.75+.04*cos(t*0.523452),.2*sin(t*0.576542), 0, 1, 0);
/*  { 
    static int cnt; 
    if ((++cnt&127)==0) {
      demogroup_doradio(syrka, 20);
      sprintf(buff, "xrad_pass%i.dat", ++pass);
      fp=fopen(buff, "w");
      demogroup_export(syrka, fp);
      fclose(fp);
    }
  }*/
  member_render(syrka);
/*  if (keys[SDLK_s]) {
    fp=fopen("bb.dat", "w");
    demogroup_export(syrka, fp);
    fclose(fp);
  }*/
  if (keys[SDLK_l]) {
    fp=fopen("rad_pass40.dat", "r");
    demogroup_import(syrka=demogroup(s, "foo"), fp, 0);
    fclose(fp);
  }
  glpopad();
}




void demota(Space *s, float timmy) {
  static int T0=0;
  static int frames=0;
  static int polys=0;
  glClear(GL_DEPTH_BUFFER_BIT|GL_COLOR_BUFFER_BIT);
  fprintf(stderr, "%8.1f\r", fmod(timmy,1)*128);
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  view3d(0.5, 0, 1);
  glPushMatrix();
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);

//  radiotest(s, timmy*5);
  dissaus(s, timmy);
  glPopMatrix();
  glPopAttrib();

  SDL_GL_SwapBuffers();
  frames++; 
  {
     int t=SDL_GetTicks();
     if (t - T0 >= 5000) {
        float seconds=(t - T0) / 1000.0;
        float fps=frames / seconds;
        float pps=polys / seconds;
        fprintf(stderr, "%d frames in %f seconds=%f FPS\n", frames, seconds, fps);
        fprintf(stderr, "%d polys in %f seconds=%f PPS\n", polys, seconds, pps);
        fprintf(stderr, "brk: %p\n", sbrk(0));
        T0=t;
        frames=0; polys=0;
     }
  }


}






