#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int segment_subdivisions;
    int export_ribbon_t_as_modifier_factor;
    int export_segment_t_as_modifier_factor;
};

struct ParticleRibbonSegmentInfo
{
    uint segments;
    uint first;
    uint previous;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct ParticleEmitterRibbon_Params
{
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
    float modifier_factor_threshold;
    int ribbons_num;
    int max_segments_num;
    float ribbon_min_remaining_lifetime;
    float ribbon_min_elapsed_lifetime;
};

struct ParticleLifecycleParams
{
    float time_step;
    float life_time_step;
    float max_lifetime;
    uint reset;
    uint capacity;
    uint has_previous;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorFromParticleProperty_Params
{
    uint property;
    uint modifier_function;
    float property_scale;
    int _pad2;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ribbon_emitter_ParticleRibbonState
{
    float generation_id;
    uint segment_info;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM5Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _406;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _437;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _460;

layout(set = 0, binding = 8, std140) uniform VM0_0
{
    ModifierFactorMulAdd_Params VM0_0_params;
} _1000;

layout(set = 0, binding = 9, std140) uniform VM0_1
{
    ModifierFactorClamp_Params VM0_1_params;
} _1013;

layout(set = 0, binding = 10, std140) uniform VM0_2
{
    ModifierFactorCurveTransfer_Params VM0_2_params;
} _1026;

layout(set = 0, binding = 4, std430) readonly buffer ribbon_emitter_RibbonStatesData
{
    ribbon_emitter_ParticleRibbonState states[];
} ribbon_emitter_prt_states_snapshots;

layout(set = 0, binding = 5, std430) restrict readonly buffer ribbon_emitter_RibbonPositionsData
{
    float position[];
} ribbon_emitter_prt_position_snapshots;

layout(set = 0, binding = 6, std430) readonly buffer ribbon_emitter_ParticleStatesData
{
    ParticleState ribbon_emitter_prt_states[];
} _1402;

layout(set = 0, binding = 11, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1784;

layout(set = 0, binding = 12, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1845;

layout(set = 0, binding = 7, std430) buffer VM0
{
    ParticleEmitterRibbon_Params VM0_params;
} _1917;

layout(set = 0, binding = 13, std140) uniform ribbon_emitter_RibbonRenderParamsBuffer
{
    RibbonRenderParams VM0_ribbon_render_params;
} _1929;

layout(set = 0, binding = 14, std140) uniform VM1
{
    ModifierFactorFromParticleProperty_Params VM1_params;
} _1972;

layout(set = 0, binding = 15, std140) uniform VM2
{
    ModifierFactorCurveTransfer_Params VM2_params;
} _1986;

layout(set = 0, binding = 16, std140) uniform VM3
{
    ParticleModifierCurl_Params VM3_params;
} _2004;

layout(set = 0, binding = 17, std140) uniform VM4
{
    ParticleModifierCurl_Params VM4_params;
} _2030;

layout(set = 0, binding = 18, std140) uniform VM5
{
    VM5Params VM5_params;
} _2051;

layout(set = 0, binding = 19) uniform sampler2D s_Curves;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_460.prt_prev_positions[(id * 3u) + 0u], _460.prt_prev_positions[(id * 3u) + 1u], _460.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _412;
    _412.life_time = _406.prt_states[id].life_time;
    _412.life_span = _406.prt_states[id].life_span;
    _412.generation_id = _406.prt_states[id].generation_id;
    _412.color = _406.prt_states[id].color;
    ParticleState _411 = _412;
    return _411;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _419;
    _419.life_time = state.life_time;
    _419.life_span = state.life_span;
    _419.generation_id = state.generation_id;
    _419.color = state.color;
    _406.prt_states[id] = _419;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

float particle_emitter_ribbon_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

ParticleRibbonSegmentInfo ribbon_decode_segment_info(RibbonRenderParams ribbon_render_params, uint segment_info)
{
    ParticleRibbonSegmentInfo si;
    si.segments = segment_info & 65535u;
    si.first = segment_info >> uint(16);
    si.previous = si.first - 1u;
    if (si.first == 0u)
    {
        si.previous = uint(ribbon_render_params.max_segments - 1);
    }
    return si;
}

uint get_ribbon_segments(RibbonRenderParams ribbon_render_params, uint ribbon_id)
{
    RibbonRenderParams param = ribbon_render_params;
    uint param_1 = ribbon_emitter_prt_states_snapshots.states[ribbon_id].segment_info;
    ParticleRibbonSegmentInfo ribbon_si = ribbon_decode_segment_info(param, param_1);
    int s = max(0, (min(ribbon_render_params.max_segments, int(ribbon_si.segments)) - 1));
    return uint(max(1, s));
}

int calculate_vidx_for_ribbon_segment(RibbonRenderParams ribbon_render_params, uint ribbon_id, inout int ribbon_segment)
{
    RibbonRenderParams param = ribbon_render_params;
    uint param_1 = ribbon_emitter_prt_states_snapshots.states[ribbon_id].segment_info;
    ParticleRibbonSegmentInfo ribbon_si = ribbon_decode_segment_info(param, param_1);
    ribbon_segment = int(ribbon_si.first) - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += ribbon_render_params.max_segments;
    }
    int vidx = (ribbon_segment * ribbon_render_params.particles_per_segment) + int(ribbon_id);
    return vidx;
}

vec3 ribbon_get_coords_for_vidx(RibbonRenderParams ribbon_render_params, int vidx)
{
    return vec3(ribbon_emitter_prt_position_snapshots.position[(vidx * 3) + 0], ribbon_emitter_prt_position_snapshots.position[(vidx * 3) + 1], ribbon_emitter_prt_position_snapshots.position[(vidx * 3) + 2]);
}

vec3 catmull_rom(vec3 p0, vec3 p1, vec3 p2, vec3 p3, float t)
{
    float t2 = t * t;
    float t3 = t2 * t;
    return ((((p1 * 2.0) + (((-p0) + p2) * t)) + (((((p0 * 2.0) - (p1 * 5.0)) + (p2 * 4.0)) - p3) * t2)) + (((((-p0) + (p1 * 3.0)) - (p2 * 3.0)) + p3) * t3)) * 0.5;
}

vec3 ribbon_get_coords_for_t_spline(RibbonRenderParams ribbon_render_params, uint ribbon_idx, uint segment_idx, float t)
{
    RibbonRenderParams param = ribbon_render_params;
    uint param_1 = ribbon_idx;
    int control_points_num = int(get_ribbon_segments(param, param_1)) + 1;
    int s1 = int(segment_idx);
    int s2 = min((s1 + 1), (control_points_num - 1));
    int s0 = max((s1 - 1), 0);
    int s3 = min((s2 + 1), (control_points_num - 1));
    RibbonRenderParams param_2 = ribbon_render_params;
    uint param_3 = ribbon_idx;
    int param_4 = s0;
    int _1212 = calculate_vidx_for_ribbon_segment(param_2, param_3, param_4);
    int vidx0 = _1212;
    RibbonRenderParams param_5 = ribbon_render_params;
    uint param_6 = ribbon_idx;
    int param_7 = s1;
    int _1220 = calculate_vidx_for_ribbon_segment(param_5, param_6, param_7);
    int vidx1 = _1220;
    RibbonRenderParams param_8 = ribbon_render_params;
    uint param_9 = ribbon_idx;
    int param_10 = s2;
    int _1228 = calculate_vidx_for_ribbon_segment(param_8, param_9, param_10);
    int vidx2 = _1228;
    RibbonRenderParams param_11 = ribbon_render_params;
    uint param_12 = ribbon_idx;
    int param_13 = s3;
    int _1236 = calculate_vidx_for_ribbon_segment(param_11, param_12, param_13);
    int vidx3 = _1236;
    RibbonRenderParams param_14 = ribbon_render_params;
    int param_15 = vidx0;
    vec3 p0 = ribbon_get_coords_for_vidx(param_14, param_15);
    RibbonRenderParams param_16 = ribbon_render_params;
    int param_17 = vidx1;
    vec3 p1 = ribbon_get_coords_for_vidx(param_16, param_17);
    RibbonRenderParams param_18 = ribbon_render_params;
    int param_19 = vidx2;
    vec3 p2 = ribbon_get_coords_for_vidx(param_18, param_19);
    RibbonRenderParams param_20 = ribbon_render_params;
    int param_21 = vidx3;
    vec3 p3 = ribbon_get_coords_for_vidx(param_20, param_21);
    if (s0 == s1)
    {
        p0 = p1 - (p2 - p1);
    }
    if (s3 == s2)
    {
        p3 = p2 + (p2 - p1);
    }
    if (false)
    {
        float d = length(p1 - p0);
        p0 = p1 - (normalize(p1 - p0) * d);
        p3 = p2 + (normalize(p3 - p2) * d);
    }
    vec3 param_22 = p0;
    vec3 param_23 = p1;
    vec3 param_24 = p2;
    vec3 param_25 = p3;
    float param_26 = t;
    return catmull_rom(param_22, param_23, param_24, param_25, param_26);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _501 = color_convert_uint_to_float3(param);
    c.x = _501.x;
    c.y = _501.y;
    c.z = _501.z;
    return c;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

ModifierFactor particle_emitter_ribbon_emit_evaluate_modifier_VM0(inout ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorMulAdd_Params _1005;
    _1005.multiply_value = _1000.VM0_0_params.multiply_value;
    _1005.add_value = _1000.VM0_0_params.add_value;
    ModifierFactorMulAdd_Params param = _1005;
    ModifierFactor param_1 = modifier_factor;
    modifier_factor_mul_add(param, param_1);
    modifier_factor = param_1;
    ModifierFactorClamp_Params _1018;
    _1018.clamp_min = _1013.VM0_1_params.clamp_min;
    _1018.clamp_max = _1013.VM0_1_params.clamp_max;
    _1018.clamp_min_enable = _1013.VM0_1_params.clamp_min_enable;
    _1018.clamp_max_enable = _1013.VM0_1_params.clamp_max_enable;
    ModifierFactorClamp_Params param_2 = _1018;
    ModifierFactor param_3 = modifier_factor;
    modifier_factor_clamp(param_2, param_3);
    modifier_factor = param_3;
    ModifierFactorCurveTransfer_Params _1031;
    _1031.curve_idx = _1026.VM0_2_params.curve_idx;
    _1031.input_range_min = _1026.VM0_2_params.input_range_min;
    _1031.input_range_max = _1026.VM0_2_params.input_range_max;
    _1031.amplitude = _1026.VM0_2_params.amplitude;
    _1031.base = _1026.VM0_2_params.base;
    ModifierFactorCurveTransfer_Params param_4 = _1031;
    ModifierFactor param_5 = modifier_factor;
    modifier_factor_curve_transfer(param_4, param_5);
    modifier_factor = param_5;
    return modifier_factor;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    float generation_id = state.generation_id + 1.0;
    if (generation_id > 65536.0)
    {
        generation_id = 0.0;
    }
    state.generation_id = generation_id;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _514 = color_convert_rgb_float3_uint(param);
    uint v = _514;
    state.color = v;
}

void particle_emitter_ribbon_emit_VM0(ParticleEmitterRibbon_Params emitter_params, RibbonRenderParams ribbon_render_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_ribbon_rand(param)));
    uint ribbon_segments = 0u;
    int ribbon_id;
    ParticleState ribbon_state;
    for (int iteration = 0; iteration < 5; iteration++)
    {
        float param_1 = (fid * 0.0130000002682209014892578125) + (float(iteration) * 0.712999999523162841796875);
        ribbon_id = int(float(emitter_params.ribbons_num) * particle_emitter_ribbon_rand(param_1));
        ParticleState _1406;
        _1406.life_time = _1402.ribbon_emitter_prt_states[ribbon_id].life_time;
        _1406.life_span = _1402.ribbon_emitter_prt_states[ribbon_id].life_span;
        _1406.generation_id = _1402.ribbon_emitter_prt_states[ribbon_id].generation_id;
        _1406.color = _1402.ribbon_emitter_prt_states[ribbon_id].color;
        ribbon_state = _1406;
        ParticleState param_2 = ribbon_state;
        if (prt_is_alive(param_2) == false)
        {
            continue;
        }
        if (ribbon_state.life_time < emitter_params.ribbon_min_elapsed_lifetime)
        {
            continue;
        }
        if ((ribbon_state.life_span - ribbon_state.life_time) < emitter_params.ribbon_min_remaining_lifetime)
        {
            continue;
        }
        RibbonRenderParams param_3 = ribbon_render_params;
        uint param_4 = uint(ribbon_id);
        ribbon_segments = get_ribbon_segments(param_3, param_4);
        if (ribbon_segments <= 1u)
        {
            continue;
        }
        break;
    }
    ParticleState param_5 = ribbon_state;
    if ((prt_is_alive(param_5) == false) || (ribbon_segments <= 1u))
    {
        return;
    }
    for (int iteration_1 = 0; iteration_1 < 15; iteration_1++)
    {
        float param_6 = ((fid * 0.112999998033046722412109375) + 132.1410064697265625) + (float(iteration_1) * 0.712999999523162841796875);
        float ribbon_t = particle_emitter_ribbon_rand(param_6);
        float ribbon_segment_t = fract(ribbon_t * float(ribbon_render_params.max_segments - 1));
        int ribbon_segment = int(floor(ribbon_t * float(ribbon_render_params.max_segments - 1)));
        if (uint(ribbon_segment) >= (ribbon_segments - 1u))
        {
            continue;
        }
        RibbonRenderParams param_7 = ribbon_render_params;
        uint param_8 = uint(ribbon_id);
        uint param_9 = uint(ribbon_segment);
        float param_10 = ribbon_segment_t;
        vec3 pos = ribbon_get_coords_for_t_spline(param_7, param_8, param_9, param_10);
        ModifierFactor local_modifier_factor = modifier_factor_defaults();
        local_modifier_factor.factor = ribbon_t * float(ribbon_render_params.max_segments - 1);
        local_modifier_factor.hash = floatBitsToUint(fid);
        local_modifier_factor.id = id;
        local_modifier_factor.position = pos;
        local_modifier_factor.is_spawned = true;
        ParticleState param_11 = ribbon_state;
        local_modifier_factor.color = prt_get_color(param_11);
        ModifierFactor param_12 = local_modifier_factor;
        ModifierFactor _1539 = particle_emitter_ribbon_emit_evaluate_modifier_VM0(param_12);
        local_modifier_factor = _1539;
        if (local_modifier_factor.factor <= emitter_params.modifier_factor_threshold)
        {
            continue;
        }
        p.pos = pos;
        ParticleState param_13 = p.state;
        float param_14 = lifetime;
        prt_spawn(param_13, param_14);
        p.state = param_13;
        ParticleState param_15 = p.state;
        vec3 param_16 = emitter_params.particle_color.xyz;
        prt_set_color(param_15, param_16);
        p.state = param_15;
        return;
    }
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_from_particle_property(ModifierFactorFromParticleProperty_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    uint id = modifier_factor.id;
    uint param = id;
    ParticleState state = prt_get_state(param);
    ParticleState param_1 = state;
    if (prt_is_alive(param_1) == false)
    {
        return;
    }
    float v = 0.0;
    if (modifier_params.property == 0u)
    {
        v = state.life_time;
    }
    else
    {
        if (modifier_params.property == 1u)
        {
            v = max(0.0, state.life_span - state.life_time);
        }
        else
        {
            if (modifier_params.property == 2u)
            {
                v = state.generation_id;
            }
        }
    }
    v *= modifier_params.property_scale;
    ModifierFactor param_2 = modifier_factor;
    uint param_3 = modifier_params.modifier_function;
    float param_4 = v;
    modifier_process_modifier_factor(param_2, param_3, param_4);
    modifier_factor = param_2;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1784.globals.time, _1784.globals.time * 0.3014999926090240478515625, (-_1784.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1807 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1807 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_position(uint id, vec3 p)
{
    _437.prt_positions[(id * 3u) + 0u] = p.x;
    _437.prt_positions[(id * 3u) + 1u] = p.y;
    _437.prt_positions[(id * 3u) + 2u] = p.z;
}

void prt_set_prev_position(uint id, vec3 p)
{
    _460.prt_prev_positions[(id * 3u) + 0u] = p.x;
    _460.prt_prev_positions[(id * 3u) + 1u] = p.y;
    _460.prt_prev_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    float prev_generation_id = p.state.generation_id;
    if (_1845.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    if (id >= _1845.lifecycle_params.capacity)
    {
        ParticleState param_3 = p.state;
        prt_kill(param_3);
        p.state = param_3;
        uint param_4 = id;
        ParticleState param_5 = p.state;
        prt_set_state(param_4, param_5);
        return;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    ParticleState param_6 = p.state;
    vec3 _1890;
    if (prt_is_alive(param_6))
    {
        _1890 = p.pos;
    }
    else
    {
        _1890 = vec3(0.0);
    }
    modifier_factor.position = _1890;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_7 = p.state;
    if (!prt_is_alive(param_7))
    {
        int _1921 = atomicAdd(_1917.VM0_params.pending, -1);
        int pending = _1921;
        if (pending > 0)
        {
            ParticleEmitterRibbon_Params _1934;
            _1934.particle_color = _1917.VM0_params.particle_color;
            _1934.particle_lifetime = _1917.VM0_params.particle_lifetime;
            _1934.particle_lifetime_randomness = _1917.VM0_params.particle_lifetime_randomness;
            _1934.rate = _1917.VM0_params.rate;
            _1934.seed = _1917.VM0_params.seed;
            _1934.pending = _1917.VM0_params.pending;
            _1934.modifier_factor_threshold = _1917.VM0_params.modifier_factor_threshold;
            _1934.ribbons_num = _1917.VM0_params.ribbons_num;
            _1934.max_segments_num = _1917.VM0_params.max_segments_num;
            _1934.ribbon_min_remaining_lifetime = _1917.VM0_params.ribbon_min_remaining_lifetime;
            _1934.ribbon_min_elapsed_lifetime = _1917.VM0_params.ribbon_min_elapsed_lifetime;
            ParticleEmitterRibbon_Params param_8 = _1934;
            RibbonRenderParams _1939;
            _1939.max_segments = _1929.VM0_ribbon_render_params.max_segments;
            _1939.base_idx = _1929.VM0_ribbon_render_params.base_idx;
            _1939.base_segment = _1929.VM0_ribbon_render_params.base_segment;
            _1939.particles_per_segment = _1929.VM0_ribbon_render_params.particles_per_segment;
            _1939.thickness = _1929.VM0_ribbon_render_params.thickness;
            _1939.lights_num = _1929.VM0_ribbon_render_params.lights_num;
            _1939.material_index = _1929.VM0_ribbon_render_params.material_index;
            _1939.first_segment_time_factor = _1929.VM0_ribbon_render_params.first_segment_time_factor;
            _1939.render_as_strips = _1929.VM0_ribbon_render_params.render_as_strips;
            _1939.segment_subdivisions = _1929.VM0_ribbon_render_params.segment_subdivisions;
            _1939.export_ribbon_t_as_modifier_factor = _1929.VM0_ribbon_render_params.export_ribbon_t_as_modifier_factor;
            _1939.export_segment_t_as_modifier_factor = _1929.VM0_ribbon_render_params.export_segment_t_as_modifier_factor;
            RibbonRenderParams param_9 = _1939;
            ParticleLifecycleParams _1944;
            _1944.time_step = _1845.lifecycle_params.time_step;
            _1944.life_time_step = _1845.lifecycle_params.life_time_step;
            _1944.max_lifetime = _1845.lifecycle_params.max_lifetime;
            _1944.reset = _1845.lifecycle_params.reset;
            _1944.capacity = _1845.lifecycle_params.capacity;
            _1944.has_previous = _1845.lifecycle_params.has_previous;
            ParticleLifecycleParams param_10 = _1944;
            Particle param_11 = p;
            uint param_12 = id;
            particle_emitter_ribbon_emit_VM0(param_8, param_9, param_10, param_11, param_12);
            p = param_11;
            ParticleState param_13 = p.state;
            if (prt_is_alive(param_13) == false)
            {
                int _1959 = atomicAdd(_1917.VM0_params.pending, 1);
            }
        }
    }
    ParticleState param_14 = p.state;
    if (prt_is_alive(param_14))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorFromParticleProperty_Params _1977;
    _1977.property = _1972.VM1_params.property;
    _1977.modifier_function = _1972.VM1_params.modifier_function;
    _1977.property_scale = _1972.VM1_params.property_scale;
    _1977._pad2 = _1972.VM1_params._pad2;
    ModifierFactorFromParticleProperty_Params param_15 = _1977;
    ModifierFactor param_16 = modifier_factor;
    CoordinateSystemTrasforms param_17 = cs_transforms;
    modifier_factor_from_particle_property(param_15, param_16, param_17);
    modifier_factor = param_16;
    ModifierFactorCurveTransfer_Params _1990;
    _1990.curve_idx = _1986.VM2_params.curve_idx;
    _1990.input_range_min = _1986.VM2_params.input_range_min;
    _1990.input_range_max = _1986.VM2_params.input_range_max;
    _1990.amplitude = _1986.VM2_params.amplitude;
    _1990.base = _1986.VM2_params.base;
    ModifierFactorCurveTransfer_Params param_18 = _1990;
    ModifierFactor param_19 = modifier_factor;
    modifier_factor_curve_transfer(param_18, param_19);
    modifier_factor = param_19;
    ParticleState param_20 = p.state;
    if (prt_is_alive(param_20))
    {
        ParticleModifierCurl_Params _2009;
        _2009.position = _2004.VM3_params.position;
        _2009.falloff_mode = _2004.VM3_params.falloff_mode;
        _2009.radius = _2004.VM3_params.radius;
        _2009.falloff_inverse = _2004.VM3_params.falloff_inverse;
        _2009.noise_strength = _2004.VM3_params.noise_strength;
        _2009.noise_speed = _2004.VM3_params.noise_speed;
        _2009.noise_scale = _2004.VM3_params.noise_scale;
        ParticleModifierCurl_Params param_21 = _2009;
        ParticleLifecycleParams _2013;
        _2013.time_step = _1845.lifecycle_params.time_step;
        _2013.life_time_step = _1845.lifecycle_params.life_time_step;
        _2013.max_lifetime = _1845.lifecycle_params.max_lifetime;
        _2013.reset = _1845.lifecycle_params.reset;
        _2013.capacity = _1845.lifecycle_params.capacity;
        _2013.has_previous = _1845.lifecycle_params.has_previous;
        ParticleLifecycleParams param_22 = _2013;
        ModifierFactor param_23 = modifier_factor;
        Particle param_24 = p;
        uint param_25 = id;
        particle_modifier_curl(param_21, param_22, param_23, param_24, param_25);
        p = param_24;
    }
    ParticleState param_26 = p.state;
    if (prt_is_alive(param_26))
    {
        ParticleModifierCurl_Params _2034;
        _2034.position = _2030.VM4_params.position;
        _2034.falloff_mode = _2030.VM4_params.falloff_mode;
        _2034.radius = _2030.VM4_params.radius;
        _2034.falloff_inverse = _2030.VM4_params.falloff_inverse;
        _2034.noise_strength = _2030.VM4_params.noise_strength;
        _2034.noise_speed = _2030.VM4_params.noise_speed;
        _2034.noise_scale = _2030.VM4_params.noise_scale;
        ParticleModifierCurl_Params param_27 = _2034;
        ParticleLifecycleParams _2038;
        _2038.time_step = _1845.lifecycle_params.time_step;
        _2038.life_time_step = _1845.lifecycle_params.life_time_step;
        _2038.max_lifetime = _1845.lifecycle_params.max_lifetime;
        _2038.reset = _1845.lifecycle_params.reset;
        _2038.capacity = _1845.lifecycle_params.capacity;
        _2038.has_previous = _1845.lifecycle_params.has_previous;
        ParticleLifecycleParams param_28 = _2038;
        ModifierFactor param_29 = modifier_factor;
        Particle param_30 = p;
        uint param_31 = id;
        particle_modifier_curl(param_27, param_28, param_29, param_30, param_31);
        p = param_30;
    }
    vec3 modifier_position = _2051.VM5_params.position;
    p.pos += ((_2051.VM5_params.velocity * _1845.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_32 = p.state;
    float param_33 = _1845.lifecycle_params.life_time_step;
    float param_34 = _1845.lifecycle_params.max_lifetime;
    prt_advance_life(param_32, param_33, param_34);
    p.state = param_32;
    uint param_35 = id;
    ParticleState param_36 = p.state;
    prt_set_state(param_35, param_36);
    uint param_37 = id;
    vec3 param_38 = p.pos;
    prt_set_position(param_37, param_38);
    bool _2093 = _1845.lifecycle_params.has_previous != 0u;
    bool _2100;
    if (_2093)
    {
        _2100 = p.state.generation_id != prev_generation_id;
    }
    else
    {
        _2100 = _2093;
    }
    if (_2100)
    {
        uint param_39 = id;
        vec3 param_40 = p.pos;
        prt_set_prev_position(param_39, param_40);
    }
}

 