#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct CustomPostprocessParams
{
    float param1;
    float param2;
    float param3;
    float param4;
    vec4 param_color1;
    vec4 param_color2;
    int txt1_flip_y;
    int txt2_flip_y;
    int txt3_flip_y;
    int _pad0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct BasicDeferredParams
{
    mat4 mModel;
    mat4 mModelview;
    mat4 mCameraModelview;
    mat4 mProjection;
    vec4 camera_projection_params;
    vec4 camera_near_far_plane;
    vec3 camera_position;
};

layout(set = 1, binding = 1, std140) uniform CustomPostprocessParamsBuffer
{
    CustomPostprocessParams params;
} _406;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

float get_d(vec2 p)
{
    float m = max(0.0, sin(_406.params.param1 + (p.y * _406.params.param2)));
    return m;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec4 get_c_fast(vec2 p, vec2 off, float m)
{
    vec2 p_quant = p;
    p_quant = vec2(ivec2(p_quant * 64.0)) / vec2(64.0);
    vec2 p_quant_coarse = p;
    p_quant_coarse = vec2(ivec2(p_quant_coarse * 12.0)) / vec2(12.0);
    p_quant_coarse += p_quant;
    vec2 p_quant_fine = p;
    p_quant_fine = vec2(ivec2(p_quant_fine * 256.0)) / vec2(256.0);
    p_quant_fine.x = 0.0;
    vec3 param = vec3(p_quant * 10.0, 0.231000006198883056640625 + _406.params.param4);
    float n = (snoise(param) * 0.100000001490116119384765625) * m;
    vec3 param_1 = vec3(p_quant_coarse * 4.0, (0.120999999344348907470703125 + (_406.params.param4 * 10.0)) + p_quant_coarse.y);
    float n_coarse = snoise(param_1) * 2.0;
    n_coarse = max(0.0, n_coarse - _406.params.param3) * m;
    vec3 param_2 = vec3(p_quant_fine * 40.0, 0.721210002899169921875 + _406.params.param4);
    float n_fine = (snoise(param_2) * 0.100000001490116119384765625) * m;
    vec4 c = texture(s_texture0, (p + off) + vec2(n));
    vec4 c_1 = texture(s_texture0, (p + off) + vec2(n_fine, 0.0));
    vec4 c_coarse = texture(s_texture0, (p + off) + vec2(n_coarse));
    return (mix(c_1, c, vec4(c.x)) * 0.300000011920928955078125) + (c_coarse * 0.699999988079071044921875);
}

void main()
{
    vec2 p = vTexcoord0;
    vec4 c = vec4(0.0);
    vec2 param = p;
    float m = get_d(param);
    int n = 10;
    for (int i = 0; i < 10; i++)
    {
        float t = 0.001000000047497451305389404296875 * m;
        vec2 param_1 = p;
        vec2 param_2 = (vec2(float(i), 0.0) * t) * 1.0;
        float param_3 = m;
        c.x += get_c_fast(param_1, param_2, param_3).x;
        vec2 param_4 = p;
        vec2 param_5 = (vec2(float(i), 0.0) * t) * 2.2000000476837158203125;
        float param_6 = m;
        c.y += get_c_fast(param_4, param_5, param_6).y;
        vec2 param_7 = p;
        vec2 param_8 = (vec2(float(i), 0.0) * t) * 4.400000095367431640625;
        float param_9 = m;
        c.z += get_c_fast(param_7, param_8, param_9).z;
    }
    c *= 0.100000001490116119384765625;
    vec2 uv = p * (vec2(1.0) - p.yx);
    float vf = (uv.x * uv.y) * 15.0;
    vf = pow(vf, 0.25);
    c *= vf;
    outColor = max(vec4(0.0), c * (vec4(1.0) + (_406.params.param_color1 * m)));
}

 