#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 4, local_size_y = 4, local_size_z = 2) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 6) uniform sampler3D sSourceColor;
layout(set = 0, binding = 1, r8) uniform readonly image3D imSourceOccupancy;
layout(set = 0, binding = 2, r32ui) uniform writeonly uimage3D imTarget0Color;
layout(set = 0, binding = 3, r8) uniform writeonly image3D imTarget0Occupancy;
layout(set = 0, binding = 4, r32ui) uniform writeonly uimage3D imTarget1Color;
layout(set = 0, binding = 5, r8) uniform writeonly image3D imTarget1Occupancy;

vec4 vx_correct_after_downsampling(inout vec4 v)
{
    v *= 2.0;
    v.w = min(1.0, v.w);
    return v;
}

uint color_convert_rgb_rgb9e5(inout vec3 rgb)
{
    float kMaxVal = uintBitsToFloat(1199538176u);
    float kMinVal = uintBitsToFloat(931135488u);
    rgb = clamp(rgb, vec3(0.0), vec3(kMaxVal));
    float MaxChannel = max(max(kMinVal, rgb.x), max(rgb.y, rgb.z));
    float Bias = uintBitsToFloat((floatBitsToUint(MaxChannel) + 125845504u) & 2139095040u);
    uvec3 RGB = floatBitsToUint(rgb + vec3(Bias));
    uint E = (floatBitsToUint(Bias) << uint(4)) + 268435456u;
    return ((E | (RGB.z << uint(18))) | (RGB.y << uint(9))) | (RGB.x & 511u);
}

void main()
{
    ivec3 grid_pos_16x16x16 = ivec3(gl_WorkGroupID);
    ivec3 grid_pos = (grid_pos_16x16x16 * ivec3(16, 16, 8)) + (ivec3(gl_LocalInvocationID) * ivec3(4));
    int grid_size = int((4u * gl_NumWorkGroups.x) * 4u);
    vec4 cube_samples_mip1[2][2][2];
    for (int iz = 0; iz < 2; iz++)
    {
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                cube_samples_mip1[iz][iy][ix] = vec4(0.0);
            }
        }
    }
    ivec3 store_pos = grid_pos;
    vec4 v;
    for (int iz_1 = 0; iz_1 < 4; iz_1++)
    {
        for (int iy_1 = 0; iy_1 < 4; iy_1++)
        {
            for (int ix_1 = 0; ix_1 < 4; ix_1++)
            {
                int source_off = (store_pos.x + (store_pos.y * grid_size)) + ((store_pos.z * grid_size) * grid_size);
                vec3 _228 = texelFetch(sSourceColor, store_pos, 2).xyz;
                v.x = _228.x;
                v.y = _228.y;
                v.z = _228.z;
                v.w = imageLoad(imSourceOccupancy, store_pos).x;
                int _244 = iz_1 / 2;
                int _246 = iy_1 / 2;
                int _248 = ix_1 / 2;
                cube_samples_mip1[_244][_246][_248] += v;
                store_pos.x++;
            }
            store_pos.x -= 4;
            store_pos.y++;
        }
        store_pos.y -= 4;
        store_pos.z++;
    }
    vec4 cube_samples_mip2 = vec4(0.0);
    for (int iz_2 = 0; iz_2 < 2; iz_2++)
    {
        for (int iy_2 = 0; iy_2 < 2; iy_2++)
        {
            for (int ix_2 = 0; ix_2 < 2; ix_2++)
            {
                store_pos = (grid_pos / ivec3(2)) + ivec3(ix_2, iy_2, iz_2);
                vec4 samples_color = vec4(0.0);
                samples_color.w = cube_samples_mip1[iz_2][iy_2][ix_2].w;
                samples_color.x = cube_samples_mip1[iz_2][iy_2][ix_2].xyz.x;
                samples_color.y = cube_samples_mip1[iz_2][iy_2][ix_2].xyz.y;
                samples_color.z = cube_samples_mip1[iz_2][iy_2][ix_2].xyz.z;
                samples_color.w *= 0.125;
                vec4 _334 = samples_color;
                vec3 _336 = _334.xyz * 0.125;
                samples_color.x = _336.x;
                samples_color.y = _336.y;
                samples_color.z = _336.z;
                vec4 param = samples_color;
                vec4 _345 = vx_correct_after_downsampling(param);
                samples_color = _345;
                vec3 param_1 = samples_color.xyz;
                uint _354 = color_convert_rgb_rgb9e5(param_1);
                imageStore(imTarget0Color, store_pos, uvec4(_354));
                imageStore(imTarget0Occupancy, store_pos, samples_color.wwww);
                cube_samples_mip2 += samples_color;
            }
        }
    }
    vec4 samples_color_1 = vec4(0.0);
    samples_color_1.w = cube_samples_mip2.w;
    samples_color_1.x = cube_samples_mip2.xyz.x;
    samples_color_1.y = cube_samples_mip2.xyz.y;
    samples_color_1.z = cube_samples_mip2.xyz.z;
    samples_color_1.w *= 0.125;
    vec4 _387 = samples_color_1;
    vec3 _389 = _387.xyz * 0.125;
    samples_color_1.x = _389.x;
    samples_color_1.y = _389.y;
    samples_color_1.z = _389.z;
    vec4 param_2 = samples_color_1;
    vec4 _398 = vx_correct_after_downsampling(param_2);
    samples_color_1 = _398;
    vec3 param_3 = samples_color_1.xyz;
    uint _407 = color_convert_rgb_rgb9e5(param_3);
    imageStore(imTarget1Color, grid_pos / ivec3(4), uvec4(_407));
    imageStore(imTarget1Occupancy, grid_pos / ivec3(4), samples_color_1.wwww);
}

 