#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct TextureProcessParams
{
    int width;
    int height;
    float width_inv;
    float height_inv;
    float param1;
    float param2;
    float param3;
    float param4;
    vec4 param_color;
    TextureResourceParams txt_params;
    int lod;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform TextureProcessParamsBuffer
{
    TextureProcessParams texture_process_params;
} _130;

layout(set = 0, binding = 3) uniform sampler2D sSource;
layout(set = 0, binding = 2, rgba16f) uniform writeonly image2D imDest;

float erf(inout float x)
{
    float a1 = 0.254829585552215576171875;
    float a2 = -0.284496724605560302734375;
    float a3 = 1.42141377925872802734375;
    float a4 = -1.45315206050872802734375;
    float a5 = 1.0614054203033447265625;
    float p = 0.3275910913944244384765625;
    float _sign = (x < 0.0) ? (-1.0) : 1.0;
    x = abs(x);
    float t = 1.0 / (1.0 + (p * x));
    float y = 1.0 - ((((((((((a5 * t) + a4) * t) + a3) * t) + a2) * t) + a1) * t) * exp((-x) * x));
    return _sign * y;
}

float integratedGaussian(float x, float sigma)
{
    float a = (x - 0.5) / sigma;
    float b = (x + 0.5) / sigma;
    float param = b / 1.41421353816986083984375;
    float _94 = erf(param);
    float param_1 = a / 1.41421353816986083984375;
    float _98 = erf(param_1);
    return 0.5 * (_94 - _98);
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    vec2 texel_size = vec2(_130.texture_process_params.width_inv, _130.texture_process_params.height_inv);
    vec2 vTexCoord = vec2(pixel_pos) * texel_size;
    float lod = float(_130.texture_process_params.lod);
    float sigma = max(0.0, _130.texture_process_params.param1);
    float param = 0.0;
    float param_1 = sigma;
    float w = integratedGaussian(param, param_1);
    vec4 color = textureLod(sSource, vTexCoord, lod) * w;
    for (int i = 1; i < 7; i++)
    {
        vec2 offset = vec2(float(i) * 2.0, 0.0) * texel_size;
        float param_2 = float(i) * 2.0;
        float param_3 = sigma;
        float ww = integratedGaussian(param_2, param_3);
        vec4 sample1 = textureLod(sSource, vTexCoord + offset, lod);
        vec4 sample2 = textureLod(sSource, vTexCoord - offset, lod);
        color += ((sample1 + sample2) * ww);
        w += (ww * 2.0);
    }
    color /= vec4(w);
    imageStore(imDest, ivec2(pixel_pos), color);
}

 