#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct InstancingGeneratorParams
{
    int seed;
    int first_particle;
    int skip_particles;
    int num_particles;
    float fade_lifetime;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _143;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _167;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _190;

layout(set = 0, binding = 9, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _237;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _353;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _458;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _481;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _501;

layout(set = 0, binding = 8, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _509;

bool prt_is_alive(uint id)
{
    return _143.prt_states[id].life_time < _143.prt_states[id].life_span;
}

vec3 prt_get_prev_position(uint id)
{
    return vec3(_190.prt_prev_positions[(id * 3u) + 0u], _190.prt_prev_positions[(id * 3u) + 1u], _190.prt_prev_positions[(id * 3u) + 2u]);
}

vec3 prt_get_position(uint id)
{
    return vec3(_167.prt_positions[(id * 3u) + 0u], _167.prt_positions[(id * 3u) + 1u], _167.prt_positions[(id * 3u) + 2u]);
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ParticleState prt_get_state(uint id)
{
    ParticleState _160;
    _160.life_time = _143.prt_states[id].life_time;
    _160.life_span = _143.prt_states[id].life_span;
    _160.generation_id = _143.prt_states[id].generation_id;
    _160.color = _143.prt_states[id].color;
    ParticleState _159 = _160;
    return _159;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _143.prt_states[id].color;
    vec3 _215 = color_convert_uint_to_float3(param);
    c.x = _215.x;
    c.y = _215.y;
    c.z = _215.z;
    return c;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint particle_idx = (id * uint(_237.instancing_generator_params.skip_particles)) + uint(_237.instancing_generator_params.first_particle);
    if (particle_idx >= uint(_237.instancing_generator_params.num_particles))
    {
        return;
    }
    uint param = particle_idx;
    if (prt_is_alive(param) == false)
    {
        return;
    }
    uint param_1 = particle_idx;
    vec3 pos_prev = prt_get_prev_position(param_1);
    uint param_2 = particle_idx;
    vec3 pos = prt_get_position(param_2);
    bool has_direction = true;
    bool _276 = pos.x == pos_prev.x;
    bool _284;
    if (_276)
    {
        _284 = pos.y == pos_prev.y;
    }
    else
    {
        _284 = _276;
    }
    bool _292;
    if (_284)
    {
        _292 = pos.z == pos_prev.z;
    }
    else
    {
        _292 = _284;
    }
    if (_292)
    {
        has_direction = false;
    }
    vec3 nx = vec3(1.0, 0.0, 0.0);
    vec3 ny = vec3(0.0, 1.0, 0.0);
    vec3 nz = vec3(0.0, 0.0, 1.0);
    if (has_direction)
    {
        vec3 d = normalize(pos_prev - pos);
        nz = d;
        nx = cross(nz, ny);
        ny = cross(nz, nx);
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = particle_idx;
    modifier_factor.id = id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    bool _338 = modifier_factor.factor <= 9.9999997473787516355514526367188e-05;
    bool _345;
    if (!_338)
    {
        _345 = modifier_factor.is_discarded == true;
    }
    else
    {
        _345 = _338;
    }
    if (_345)
    {
        return;
    }
    int _356 = atomicAdd(_353.instance_params.instance_count, 1);
    uint instance_id = uint(_356);
    if (instance_id >= uint(_353.instance_params.buffer_capacity))
    {
        return;
    }
    uint param_3 = particle_idx;
    ParticleState particle_state = prt_get_state(param_3);
    float size = 1.0;
    if (particle_state.life_time < _237.instancing_generator_params.fade_lifetime)
    {
        size = smoothstep(0.0, _237.instancing_generator_params.fade_lifetime, particle_state.life_time);
    }
    if (particle_state.life_time >= (particle_state.life_span - _237.instancing_generator_params.fade_lifetime))
    {
        size = 1.0 - smoothstep(particle_state.life_span - _237.instancing_generator_params.fade_lifetime, particle_state.life_span, particle_state.life_time);
    }
    nx *= size;
    ny *= size;
    nz *= size;
    Instance instance;
    instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
    instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
    instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
    instance.hash = modifier_factor.hash;
    uint param_4 = particle_idx;
    instance.c = prt_get_color(param_4);
    instance.flipbook_card = 0u;
    _458.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _458.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _458.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _481.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _481.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _501.instance_hash[instance_id] = instance.hash;
    _509.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 