#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(vertices = 3) out;

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 3, binding = 1, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _40;

layout(location = 1) in Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_inputs[32];

layout(location = 1) out Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_outputs[3];

layout(location = 0) out uint instanceID_outputs[3];
layout(location = 0) in uint instanceID_inputs[];

void main()
{
    if (gl_InvocationID == 0)
    {
        float d = length(vtx_inputs[gl_InvocationID].vCameraRelativeWorldPos);
        d = 1.0 - (min(d, _40.transform_params.tesselationMaxDistance) / _40.transform_params.tesselationMaxDistance);
        d = pow(d, 3.0);
        float a = abs(0.5 * length(cross(vtx_inputs[2].vLocalPos - vtx_inputs[0].vLocalPos, vtx_inputs[1].vLocalPos - vtx_inputs[0].vLocalPos)));
        a = max(0.0, a - _40.transform_params.tesselationMinArea) * _40.transform_params.tesselationAreaFactor;
        float s = clamp((d + a) * _40.transform_params.tesselationMaxFactor, 1.0, 16.0);
        gl_TessLevelInner[0] = s;
        gl_TessLevelOuter[0] = s;
        gl_TessLevelOuter[1] = s;
        gl_TessLevelOuter[2] = s;
    }
    vtx_outputs[gl_InvocationID].vCoords = vtx_inputs[gl_InvocationID].vCoords;
    vtx_outputs[gl_InvocationID].vNorm = vtx_inputs[gl_InvocationID].vNorm;
    vtx_outputs[gl_InvocationID].vWorldNorm = vtx_inputs[gl_InvocationID].vWorldNorm;
    vtx_outputs[gl_InvocationID].vLocalPos = vtx_inputs[gl_InvocationID].vLocalPos;
    vtx_outputs[gl_InvocationID].vCameraRelativeWorldPos = vtx_inputs[gl_InvocationID].vCameraRelativeWorldPos;
    vtx_outputs[gl_InvocationID].vColor = vtx_inputs[gl_InvocationID].vColor;
    vtx_outputs[gl_InvocationID].vUV0 = vtx_inputs[gl_InvocationID].vUV0;
    instanceID_outputs[gl_InvocationID] = instanceID_inputs[gl_InvocationID];
    gl_out[gl_InvocationID].gl_Position = gl_in[gl_InvocationID].gl_Position;
}

 