#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct ParticleLifecycleParams
{
    float time_step;
    float life_time_step;
    float max_lifetime;
    uint reset;
    uint capacity;
    uint has_previous;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VM3Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _291;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _322;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _345;

layout(set = 0, binding = 5, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1105;

layout(set = 0, binding = 4, std430) buffer VM0
{
    layout(row_major) ParticleEmitterPrimitive_Params VM0_params;
} _1177;

layout(set = 0, binding = 6, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1214;

layout(set = 0, binding = 7, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _1228;

layout(set = 0, binding = 8, std140) uniform VM3
{
    VM3Params VM3_params;
} _1243;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_345.prt_prev_positions[(id * 3u) + 0u], _345.prt_prev_positions[(id * 3u) + 1u], _345.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _297;
    _297.life_time = _291.prt_states[id].life_time;
    _297.life_span = _291.prt_states[id].life_span;
    _297.generation_id = _291.prt_states[id].generation_id;
    _297.color = _291.prt_states[id].color;
    ParticleState _296 = _297;
    return _296;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _304;
    _304.life_time = state.life_time;
    _304.life_span = state.life_span;
    _304.generation_id = state.generation_id;
    _304.color = state.color;
    _291.prt_states[id] = _304;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    float generation_id = state.generation_id + 1.0;
    if (generation_id > 65536.0)
    {
        generation_id = 0.0;
    }
    state.generation_id = generation_id;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _385 = color_convert_rgb_float3_uint(param);
    uint v = _385;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    vec3 _491 = vector_transform_by_mat43(param_6, param_7);
    pos = _491;
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1029 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1029;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1047 = vector_transform_by_mat43(param, param_1);
        coords = _1047;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1054 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1054;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_position(uint id, vec3 p)
{
    _322.prt_positions[(id * 3u) + 0u] = p.x;
    _322.prt_positions[(id * 3u) + 1u] = p.y;
    _322.prt_positions[(id * 3u) + 2u] = p.z;
}

void prt_set_prev_position(uint id, vec3 p)
{
    _345.prt_prev_positions[(id * 3u) + 0u] = p.x;
    _345.prt_prev_positions[(id * 3u) + 1u] = p.y;
    _345.prt_prev_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    float prev_generation_id = p.state.generation_id;
    if (_1105.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    if (id >= _1105.lifecycle_params.capacity)
    {
        ParticleState param_3 = p.state;
        prt_kill(param_3);
        p.state = param_3;
        uint param_4 = id;
        ParticleState param_5 = p.state;
        prt_set_state(param_4, param_5);
        return;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    ParticleState param_6 = p.state;
    vec3 _1150;
    if (prt_is_alive(param_6))
    {
        _1150 = p.pos;
    }
    else
    {
        _1150 = vec3(0.0);
    }
    modifier_factor.position = _1150;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_7 = p.state;
    if (!prt_is_alive(param_7))
    {
        int _1181 = atomicAdd(_1177.VM0_params.pending, -1);
        int pending = _1181;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _1190;
            _1190.transform = _1177.VM0_params.transform;
            _1190.particle_color = _1177.VM0_params.particle_color;
            _1190.primitive_size = _1177.VM0_params.primitive_size;
            _1190.perimeter_only = _1177.VM0_params.perimeter_only;
            _1190.primitive_type = _1177.VM0_params.primitive_type;
            _1190.particle_lifetime = _1177.VM0_params.particle_lifetime;
            _1190.particle_lifetime_randomness = _1177.VM0_params.particle_lifetime_randomness;
            _1190.rate = _1177.VM0_params.rate;
            _1190.seed = _1177.VM0_params.seed;
            _1190.pending = _1177.VM0_params.pending;
            ParticleEmitterPrimitive_Params param_8 = _1190;
            ParticleLifecycleParams _1195;
            _1195.time_step = _1105.lifecycle_params.time_step;
            _1195.life_time_step = _1105.lifecycle_params.life_time_step;
            _1195.max_lifetime = _1105.lifecycle_params.max_lifetime;
            _1195.reset = _1105.lifecycle_params.reset;
            _1195.capacity = _1105.lifecycle_params.capacity;
            _1195.has_previous = _1105.lifecycle_params.has_previous;
            ParticleLifecycleParams param_9 = _1195;
            Particle param_10 = p;
            uint param_11 = id;
            particle_emitter_primitive_emit(param_8, param_9, param_10, param_11);
            p = param_10;
        }
    }
    ParticleState param_12 = p.state;
    if (prt_is_alive(param_12))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorNoise_Params _1219;
    _1219.transform_local_to_gizmo = _1214.VM1_params.transform_local_to_gizmo;
    _1219.noise_domain_scale = _1214.VM1_params.noise_domain_scale;
    _1219.modifier_function = _1214.VM1_params.modifier_function;
    _1219.noise_domain_offset = _1214.VM1_params.noise_domain_offset;
    _1219.noise_value_scale = _1214.VM1_params.noise_value_scale;
    _1219.noise_value_offset = _1214.VM1_params.noise_value_offset;
    _1219.influence_scope = _1214.VM1_params.influence_scope;
    _1219._pad0 = _1214.VM1_params._pad0;
    _1219._pad1 = _1214.VM1_params._pad1;
    ModifierFactorNoise_Params param_13 = _1219;
    ModifierFactor param_14 = modifier_factor;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    modifier_factor_noise_simplex2(param_13, param_14, param_15);
    modifier_factor = param_14;
    ModifierFactorNoise_Params _1232;
    _1232.transform_local_to_gizmo = _1228.VM2_params.transform_local_to_gizmo;
    _1232.noise_domain_scale = _1228.VM2_params.noise_domain_scale;
    _1232.modifier_function = _1228.VM2_params.modifier_function;
    _1232.noise_domain_offset = _1228.VM2_params.noise_domain_offset;
    _1232.noise_value_scale = _1228.VM2_params.noise_value_scale;
    _1232.noise_value_offset = _1228.VM2_params.noise_value_offset;
    _1232.influence_scope = _1228.VM2_params.influence_scope;
    _1232._pad0 = _1228.VM2_params._pad0;
    _1232._pad1 = _1228.VM2_params._pad1;
    ModifierFactorNoise_Params param_16 = _1232;
    ModifierFactor param_17 = modifier_factor;
    CoordinateSystemTrasforms param_18 = cs_transforms;
    modifier_factor_noise_simplex2(param_16, param_17, param_18);
    modifier_factor = param_17;
    vec3 modifier_position = _1243.VM3_params.position;
    p.pos += ((_1243.VM3_params.velocity * _1105.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_19 = p.state;
    float param_20 = _1105.lifecycle_params.life_time_step;
    float param_21 = _1105.lifecycle_params.max_lifetime;
    prt_advance_life(param_19, param_20, param_21);
    p.state = param_19;
    uint param_22 = id;
    ParticleState param_23 = p.state;
    prt_set_state(param_22, param_23);
    uint param_24 = id;
    vec3 param_25 = p.pos;
    prt_set_position(param_24, param_25);
    bool _1286 = _1105.lifecycle_params.has_previous != 0u;
    bool _1293;
    if (_1286)
    {
        _1293 = p.state.generation_id != prev_generation_id;
    }
    else
    {
        _1293 = _1286;
    }
    if (_1293)
    {
        uint param_26 = id;
        vec3 param_27 = p.pos;
        prt_set_prev_position(param_26, param_27);
    }
}

 