
#ifndef VERTEX_MODIFIERS_COLORIZE_H
#define VERTEX_MODIFIERS_COLORIZE_H

#include <shaders/materials/commons_gradient.glsl>

struct VertexModifierColorizeParams
{
	vec3  color;
	float alpha;
	int   use_gradient;
	float color_blend;
	float alpha_blend;
	int   color_gradient_idx;
	int   mixing_mode;
};

const int VM_COLORIZE_MIXING_OVERRIDE   = 0;
const int VM_COLORIZE_MIXING_MODULATE   = 1;
const int VM_COLORIZE_MIXING_ADD        = 2;

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, inout ModifierFactor modifier_factor, inout VertexInput vtx)
{
	vec3 c  = vec3(1.0);
	float a = modifier_params.alpha;

	if (modifier_params.use_gradient != 0)
	{
		// NOTE: This is a bit weird as we do use 'factor' twice, once to sample gradient and then to blend it
		c  = gradient_sample(modifier_params.color_gradient_idx, modifier_factor.factor).rgb;
		c *= modifier_params.color.rgb;
	}
	else
	{
		c = modifier_params.color.rgb;
	}

	if (modifier_params.mixing_mode == VM_COLORIZE_MIXING_OVERRIDE)
	{
		// NOTE: because of this dual-blend mode at least don't modulate the gradient in this mode
		if (modifier_params.use_gradient == 0)
			c = c * modifier_factor.factor;
		a = a * modifier_factor.factor;
	}
	if (modifier_params.mixing_mode == VM_COLORIZE_MIXING_MODULATE)
	{
		c = mix(vtx.color.rgb, c, vec3(modifier_factor.factor));
		a = mix(vtx.color.a  , a, modifier_factor.factor);
	}
	if (modifier_params.mixing_mode == VM_COLORIZE_MIXING_ADD)
	{
		c = vtx.color.rgb + c * modifier_factor.factor;
		a = vtx.color.a   + a * modifier_factor.factor;
	}

	vtx.color.rgb = mix(vtx.color.rgb, c, vec3(modifier_params.color_blend));
	vtx.color.a   = mix(vtx.color.a  , a, modifier_params.alpha_blend);
}

#endif

