// file: dpmi.h
// description: basic DPMI structures and functions
// compiler: Watcom 10.0+
// platform: DOS, VESA 1.2+
// copyright (c) 1999 Street Raider // DDT Ent.

#ifndef DPMI_H

#define DPMI_H

typedef struct {
    signed long int EDI, ESI, EBP, xXX, EBX, EDX, ECX, EAX;
    unsigned short int Flags, ES, DS, FS, GS, IP, CS, SP, SS;
  } DPMIRegs;

// DPMI services for memory access

typedef unsigned int DosHandle;
#define DosHandle_Selector(Handle) (Handle & 0xFFFF)
#define DosHandle_Segment(Handle) (Handle >> 16)
#define DosHandleToPointer(Handle) (DosHandle_Segment(Handle) << 4)

extern DosHandle AllocDosMemory(unsigned short int Paragraphs);
#pragma aux AllocDosMemory = \
  " mov eax,0100h  " \
  " int 31h        " \
  " shl eax,16     " \
  " mov ax,dx      " \
  parm [bx] modify [eax bx dx] value [eax];

extern void FreeDosMemory(DosHandle Selector);
#pragma aux FreeDosMemory = \
  " mov eax,0101h " \
  " int 31h       " \
  parm [edx] modify [eax];

extern int GetSelectorBase(DosHandle Selector);
#pragma aux GetSelectorBase = \
  " mov eax,0006h  " \
  " int 31h        " \
  " shl ecx,16     " \
  " mov cx,dx      " \
  parm [ebx] modify [eax ecx dx] value [ecx];

extern void RealModeInterrupt(unsigned short int IntNo, DPMIRegs *Regs);
#pragma aux RealModeInterrupt = \
  " push es        " \
  " mov ax,ds      " \
  " mov es,ax      " \
  " mov eax,300h   " \
  " int 31h        " \
  " pop es         " \
  parm [bx] [edi] modify [eax];

extern int AllocSelector(void);
#pragma aux AllocSelector = \
  " mov eax,0000h  " \
  " mov ecx,0001h  " \
  " int 31h        " \
  modify [eax ecx] value [eax];

extern void FreeSelector(int Selector);
#pragma aux FreeSelector = \
  " mov eax,0001h  " \
  " int 31h        " \
  parm [ebx] modify [eax ebx];

extern void SetSelectorBase(int Selector, int Base);
#pragma aux SetSelectorBase = \
  " mov eax,0007h  " \
  " mov ecx,edx    " \
  " shr ecx,16     " \
  " and edx,0FFFFh " \
  " int 31h        " \
  parm [ebx] [edx] modify [eax ecx edx];

extern void SetSelectorLimit(int Selector, int Limit);
#pragma aux SetSelectorLimit = \
  " mov eax,0008h  " \
  " mov ecx,edx    " \
  " shr ecx,16     " \
  " and edx,0FFFFh " \
  " int 31h        " \
  parm [ebx] [edx] modify [eax ecx edx];

#endif // DPMI_H
