\DICEROLL.XPL	8-AUG-2001
\3D animation of a rolling die
\ by Boreal (aka: Loren Blaney)
\
\The XPL0 compiler used by this program is available at:
\ http://www.idcomm.com/personal/lorenblaney
\If you have any questions, feel free to write me at:
\ loren_blaney@idcomm.com
\
\This program uses a right-hand coordinate system:
\
\			       |   Z  (into screen)
\			       |  /
\			       | /
\			       |/
\		       --------+-------- X
\			      /|
\			     / |
\			    /  |
\			       |
\			       Y
\

include	\cxpl\codesi;	\run-time library routines (intrinsics)

seg char Image(1);	\buffer for setting up copy of screen image
seg char Face(6);	\101x101 pixel image (texture map) of each face
real	CorX, CorY, CorZ; \arrays: coordinates of cube's corners (vertexes)
def	S = 54.0;	\half the length of an edge of the cube (pixels)
def	IntSize = 2;	\number of bytes in an integer (2 => 16-bit XPL0)



proc	Erase(Im);	\Erase Image buffer (paint it green actually)
seg int Im;
int	I;
for I:= 0, 32000-1 do			\write two bytes at a time for speed
	Im(0, I):= $7777;		\nice shade of green, for background

\-------------------------------------------------------------------------------

proc	DrawPoly(X0, Y0, A, F);	\Draw a texture-mapped polygon
\This procedure was originally written to draw any kind of polygon, convex or
\ concave. It was hastily hacked here to draw the simple parallelograms that
\ form the faces of the die. The linked list could be replaced with a simple
\ array since there are always exactly two edges per scan line (unlike for a
\ concave polygon), but I'm too lazy to do it.
int	X0, Y0,		\location to plot polygon (coordinates of first point)
	A,		\1-dimensional array of X,Y coordinates with first value
			\ (always 4) giving the number of vertexes (X,Y pairs)
	F;		\die face number (0..5)
int	TM,		\array: die texture map dimensions
	N, HeadTbl, P, MemPtr, \used to build linked list
	Gx, Gy, Hx, Hy,	\coordinates of end points of plotted horiz scan line
	I, J,		\indexes
	X, Y,		\coordinates to plot horiz scan lines
	Y320		\Y * 320 (for speed)
	Min, Max,	\minimum and maximum Y coordinates of polygon
	Height;		\height of polygon in pixels
def	Nil= $8000;	\linked list null pointer
def	SS = 8;		\scale shift factor
int	Py, Qy, Ry, Sy,	\Y coordinates of 4 corners of 'polygon'
	Tpx, Tpy, Tqx, Tqy, Trx, Try, Tsx, Tsy,	\texture map corner coordinates
	Cg, Ch,		\relative position of horizontal line from end points
	Tx0, Ty0, Tx1, Ty1, \end points of corresponding line in texture map
	Tdx, Tdy,	\amount to step coordinates in texture map
	Tx, Ty;		\coordinates in texture map


	proc	BuildLine(I0, I1);
	\Build table containing X coordinates along polygon edge. This creates
	\ a linked list for each horizontal line that will be drawn through the
	\ polygon.
	int	I0, I1;
	int	X, Y, DX, DY, M, T, Q;
	begin
	Gx:= A(I0) + X0;   Gy:= A(I0+1) + Y0;	\get coordinates of end points
	Hx:= A(I1) + X0;   Hy:= A(I1+1) + Y0;	\ of the polygon's edge

	if Gy > Hy then
		begin				\swap end points
		T:= Gy;   Gy:= Hy;   Hy:= T;
		T:= Gx;   Gx:= Hx;   Hx:= T;
		T:= I0;   I0:= I1;   I1:= T;
		end;

	DY:= Hy - Gy;
	if DY = 0 then return;			\don't a single horiz line
	DX:= Hx - Gx;
	M:= DX<<SS / DY;			\scaled slope (rotated 90 deg)

	X:= Gx<<SS;				\scaled starting X coordinate
	for Y:= Gy-Min, Hy-Min-1 do
		begin
		T:= X>>SS;			\unscale X
		P:= HeadTbl + Y*IntSize;	\point to list header table
		loop	begin
			case of P(0)=Nil, P(0,1)>T: \if entry empty or greater
				begin		\insert item at front of list
				Q:= MemPtr;	\ (sorted left-to-right)
				MemPtr:= MemPtr + 3*IntSize;
				Q(0):= P(0);	\copy nil or pointer to larger X
				Q(1):= T;	\unscaled X
				Q(2):= I0 + I1<<8; \indexes of ends of line seg
				P(0):= Q;
				quit;
				end
			other	P:= P(0);	\follow pointers in linked list
			end;
		X:= X + M;			\next X coordinate
		end;
	end;	\BuildLine


begin	\DrawPoly
\Find maximum and minimum Y coordinates
N:= A(0);				\get number of coordinates
Min:= $7FFF;   Max:= $8000;
I:= 2;					\index of first Y coordinate in A
for J:= 1, N do
	begin
	Y:= Y0 + A(I);
	if Y > Max then Max:= Y;
	if Y < Min then Min:= Y;
	I:= I + 2;			\next Y coordinate
	end;
Height:= Max - Min + 1;

\Set up array of list headers for each horizontal scan line in the polygon.
\ The list will contain the X coordinates (lowest value first) of the edges,
\ along with the index to the coordinates for the start and end of each edge.
HeadTbl:= Reserve(Height*IntSize);
for Y:= 0, Height-1 do HeadTbl(Y):= Nil;

MemPtr:= Reserve(30000);		\set up our own heap space manager
					\ (or in-line BuildLine)
I:= 1;					\index of first coordinate in array A
for J:= 2, N do
	begin
	BuildLine(I, I+2);		\make edge of polygon between vertexes
	I:= I + 2;			\ i.e. build table of X values for edge
	end;
BuildLine(I, 1);			\make sure the polygon is closed, i.e.
					\ connect last vertex to first vertex
\    0  1  2  3  4  5  6  7  8
\A:  N  Px Py Qx Qy Rx Ry Sx Sy		array of 'polygon' vertexes
\TM: -  px py qx qy rx ry sx sy		coorsponding array of texture vertexes

TM:= [0, 0,0, 100,0, 100,100, 0,100];	\clockwise, start at upper-right corner

for Y:= Min, Max do			\draw horizontal lines to fill polygon
	begin				\ from top to bottom
	P:= HeadTbl + (Y-Min)*IntSize;
	loop	begin			\for edge on left side of polygon...
		P:= P(0);
		if P = Nil then quit;
		Gx:= P(1);		\starting X coordinate for horiz line

		I:= P(2) & $00FF;	\index of start of edge
		Sy:= A(I+1) + Y0;	\Y coordinate of start of edge
		Tsx:= TM(I);		\corresponding coordinate in texture map
		Tsy:= TM(I+1);

		I:= P(2)>>8;		\index of end of edge
		Ry:= A(I+1) + Y0;	\Y coordinate of end of edge
		Trx:= TM(I);		\corresponding coordinate in texture map
		Try:= TM(I+1);

		P:= P(0);
		if P = Nil then quit;
		Hx:= P(1);		\ending X coordinate for horiz line

		if Gx # Hx then		\same as above for edge on right side
			begin		\ of polygon...
			I:= P(2) & $00FF;
			Py:= A(I+1) + Y0;
			Tpx:= TM(I);
			Tpy:= TM(I+1);

			I:= P(2)>>8;
			Qy:= A(I+1) + Y0;
			Tqx:= TM(I);
			Tqy:= TM(I+1);

			Cg:= (Y-Ry)<<SS / (Sy-Ry);	\relative position
			Ch:= (Y-Qy)<<SS / (Py-Qy);

			Tx0:= Cg * (Tsx-Trx) + Trx<<SS;	\corresponding end points
			Ty0:= Cg * (Tsy-Try) + Try<<SS;	\ in texture map
			Tx1:= Ch * (Tpx-Tqx) + Tqx<<SS;
			Ty1:= Ch * (Tpy-Tqy) + Tqy<<SS;

			Tdx:= (Tx1-Tx0) / (Hx-Gx);	\amount to move in
			Tdy:= (Ty1-Ty0) / (Hx-Gx);	\ texture map

			Tx:= Tx0;	\coords of start of line in texture map
			Ty:= Ty0;
			Y320:= Y*320;
			for X:= Gx, Hx-1 do	\step one horiz pixel at a time
				begin
				Image(0, X + Y320):= Face(F, Tx>>SS + 101*(Ty>>SS));
				Tx:= Tx + Tdx;	\loc of next pixel in texture map
				Ty:= Ty + Tdy;
				end;
			end;
		end;
	end;
end;	\DrawPoly

\-------------------------------------------------------------------------------

proc	DrawCube;	\Draw cube
int	T, CT, F, C, I;
begin
T:= [4, 0,0, 0,0, 0,0, 0,0];		\table of 4 polygon vertex coordinates

\Table of corners: Contains indexes into CorX, CorY & CorZ arrays for each face
CT:= [	[0, 1, 3, 2],	\1
	[4, 5, 1, 0],	\2
	[4, 0, 2, 6],	\3
	[1, 5, 7, 3],	\4
	[7, 6, 2, 3],	\5
	[5, 4, 6, 7] ];	\6

for F:= 0, 5 do				\for all the faces on the cube...
	begin
	I:= 1;
	for C:= 0, 3 do				\for all the corners on a face..
		begin
		T(I):= Fix(CorX(CT(F,C)));	\X coordinate
		I:= I + 1;
		T(I):= Fix(CorY(CT(F,C)) * 0.833); \Y coord, fix aspect ratio
		I:= I + 1;			\320*3/4 = 240, 200/240 = 0.833
		end;
	if CorZ(CT(F,0)) + CorZ(CT(F,2)) > 0.0 then \Z coord of center is visible
		DrawPoly(160, 100, T, F);
	end;
end;	\DrawCube



proc	Rotate;		\Rotate the cube
int	I;
def	Cx= 0.04, Cy= 0.05, Cz=-0.03;	\determine rotation speed
begin
for I:= 0, 7 do		\rotate all 8 corners...
	begin
	CorY(I):= CorY(I) + CorZ(I)*Cx;		\rotate about X axis
	CorZ(I):= CorZ(I) - CorY(I)*Cx;
	CorZ(I):= CorZ(I) + CorX(I)*Cy;		\rotate about Y axis
	CorX(I):= CorX(I) - CorZ(I)*Cy;
	CorX(I):= CorX(I) + CorY(I)*Cz;		\rotate about Z axis
	CorY(I):= CorY(I) - CorX(I)*Cz;
	end;
end;	\Rotate

\-------------------------------------------------------------------------------

proc	MakeFaces;	\Make texture maps for the 6 die faces
int	F,	\face number
	P,	\pattern of spots
	Tbl,	\table of spot patterns for each face
	X, Y;	\coordinates


	proc	DrawCircle(X0, Y0);	\Draw a filled circle in Image array
	int	X0, Y0;		\coordinates of center (pixels)
	int	X, Y;		\coordinates (pixels)
	def	R=14;		\radius (pixels)
	begin
	for Y:= -R, R do
	    for X:= -R, R do	\(speed is not an issue here)
		begin		\smooth the edge a little with gray
		if X*X+Y*Y < R*R then Face(F, X+X0 + 101*(Y+Y0)):= $18; \gray
		if X*X+Y*Y < R*R-25 then Face(F, X+X0 + 101*(Y+Y0)):= $10; \black
		end;
	end;	\DrawCircle


begin
\Table to define location of spots on each face of a die. A spot is displayed at
\ the corresponding bit position:
\	0 1 2
\	3 4 5
\	6 7 8
Tbl:= [$010, $101, $111, $145, $155, $1C7];

for F:= 0, 5 do					\for all the faces...
	begin
	Face(F):= Malloc(101*101/16+1);		\make a light gray square
	for Y:= 0, 100 do
	    for X:= 0, 100 do			\shade of gray depends on face
		Face(F, X+101*Y):= abs(F+F-5)/2 + $1A;

	P:= Tbl(F);			\get pattern of spots for current face
	for Y:= 0, 2 do
	    for X:= 0, 2 do
		begin
		if P & 1 then DrawCircle(X*32+2+16, Y*32+2+16);
		P:= P >> 1;
		end;
	end;
end;	\MakeFaces

\===============================================================================

begin	\Main
Image(0):= Malloc(4000);		\allocate a 64000-byte staging buffer
\Coordinates defining the initial position of the 8 corners of a cube:
CorX:= [ S,	-S,	 S,	-S,	 S,	-S,	 S,	-S];
CorY:= [ S,	 S,	-S,	-S,	 S,	 S,	-S,	-S];
CorZ:= [ S,	 S,	 S,	 S,	-S,	-S,	-S,	-S];

SetVid($13);				\set 320x200x256 graphic mode

MakeFaces;
repeat	Erase(Image);
	DrawCube;
 	Blit(Image(0), 0, $A000, 0, 64*1000);	\copy image to screen
	Rotate;
	Sound(0, 1, 1);			\delay approx 1/18 second
until ChkKey;				\keystroke terminates program

Openi(0);				\eat keystroke character, for neatness
SetVid($03);				\restore normal text display
end;	\Main
