/* Cosine calculation using Taylor series
 * Written by Claus D. Volko a.k.a. Adok/Hugi on June 11, 2001
 * Table version
 *
 * Note: don't use precision > 14 or it will return wrong results due to overflow errors(?)
 * Returns good results only for about -pi to +pi
 *
 * Use CTRL+BREAK to stop execution
 */

#include <stdio.h>

typedef float radiants;

int cos_generatetable(signed int * costable, int precision)
{
  int faculty = 1, i, j;

  if(!costable) return NULL;

  for(i = 1, j = 0; i < precision; i++, j++)
  {
    faculty *= i;
    i++;
    faculty *= i;
    faculty = ~faculty ++;
    costable[j] = faculty;
  }

  return 1;
}

float cos(radiants angle, int precision, signed int * costable)
{
  float cosine = 1, xtag = 1, quangle = angle * angle;
  int j;

  if(NULL==costable) return NULL;

  for(j = 0; j < precision >> 1; j++)
  {
    xtag *= quangle;
    cosine += xtag / costable[j];
  }

  return cosine;
}


int main(void)
{
  int precision, * costable;
  radiants angle;

  printf("precision: ");
  scanf("%d", &precision);

  costable = new int[precision >> 1 + 1];
  if(!cos_generatetable(costable, precision))
  {
    printf("Memory allocation error.");
    return NULL;
  }

  while(1)
  {
    printf("\n\nangle: ");
    scanf("%f", &angle);
    printf("\ncosine: %f", cos(angle, precision, costable));
  }
}