/* Cosine calculation using Taylor series
 * Written by Claus D. Volko a.k.a. Adok/Hugi on June 11, 2001
 * Simple version with unlimited range
 *
 * Note: don't use precision > 14 or it will return wrong results due to overflow errors(?)
 *
 * Use CTRL+BREAK to stop execution
 */

#include <stdio.h>

#define PI 3.141592654

typedef float radiants;

float cos(radiants angle, int precision)
{
  float cosine = 1, xtag = 1, quangle;
  int faculty = 1, i;
  char setsignflag = 0;

  if(angle < 0) angle = -angle;			// make angle a non-negative number
  angle -= 2 * PI * (int) (angle / (2 * PI));	// make angle fit in the range 0 ... 2*PI
  if(angle > PI / 2)				// make angle fit in the range -PI ... PI/2 and remember to change sign if necessary
  {
    setsignflag++;
    angle = PI - angle;
  }

  quangle = angle * angle;

  for(i = 1; i < precision; i++ )
  {
    faculty *= i;
    i++;
    faculty *= i;
    faculty = ~faculty ++;
    xtag *= quangle;
    cosine += xtag / faculty;
  }

  if(setsignflag) cosine = -cosine;

  return cosine;
}


void main(void)
{
  int precision;
  radiants angle;

  printf("precision: ");
  scanf("%d", &precision);

  while(1)
  {
    printf("\n\nangle: ");
    scanf("%f", &angle);
    printf("\ncosine: %f", cos(angle, precision));
  }
}