(************************************************************************)
(* simple jpeg file format reader  v. 2.0                               *)
(* by Biki / Altair                                                     *)
(************************************************************************)
(* Warning i don't take any responsibility if this piece                *)
(* code will destroy your computer, make you blind or                   *)
(* burn your house. Use at your own risk.                               *)
(************************************************************************)
(* error codes:                                                         *)
(*  0 - no error                                                        *)
(*  1 - not JFIF/JPEG file                                              *)
(*  2 - File not found                                                  *)
(*  3 - Corrupted data                                                  *)
(*  4 - Format not supported yet                                        *)
(************************************************************************)
(*  06-04-2002 - fixed error checking, IDCT made faster                 *)
(*  08-04-2002 - simplified dequantization/fixed some bugs              *)
(*               IDCT made even faster                                  *)
(*  09-04-2002 - fixed quantization table decoding (thanks to Booncol)  *)
(*  12-04-2002 - support for restart intervals                          *)
(*  22-04-2002 - fixed lot's of stuff                                   *)
(*  25-04-2002 - final version 2.0                                      *)
(************************************************************************)

unit jpeg;

interface
(* the output data structure *)
type tjpeg=record
     xres,yres:longint;
     image: array[0..0] of longint;
     end;
     pjpeg=^tjpeg;
(* input data buffer *)
     tbyte=array[0..0] of byte;
     pbyte=^tbyte;

function jpeg_load (fn:string):pjpeg;
function jpeg_decode (q:pbyte;n:integer):pjpeg;
procedure jpeg_delete (p:pjpeg);
function jpeg_geterror:integer;

implementation
const

(* zig-zag scan *)
zig:array[0..63] of byte=
               (0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,
                40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,
                43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,
                46,53,60,61,54,47,55,62,63);

     (* huffman and quantization tables *)
type thuff=array[0..1,0..255] of integer;
     phuff=^thuff;
     tqtab=array[0..63] of integer;
     pqtab=^tqtab;

     (* image component *)
     tcomponent=record
       huff_ac,huff_dc:phuff;
       qtab:pqtab;
       dc_prev:integer;
       smpx,smpy:integer;
       t:array[0..255] of single;
     end;

var component:array[0..3] of tcomponent;
    hufftable_ac,hufftable_dc:array[0..3] of thuff;
    qtable:array[0..3] of tqtab;
    dctt:array[0..63] of single;
    prec,ncomp,xres,yres,xblock,yblock:integer;
    blockx,blocky:integer;
    f:file;
    chr,msk:byte;
    error_stk:array[0..63] of byte;
    error_count:integer;
    data:pbyte;
    restart_int:integer;
    bpos,bsize:integer;
    feof:boolean;
    ss_start,ss_end,sbits:integer;

(* init jpeg decoder *)
procedure jpeg_init;
var i:integer;
begin
  data:=nil;
  for i:=0 to 3 do component[i].dc_prev:=0;
  error_count:=0;
end;

(* report error *)
procedure error(n:integer);
begin
  if error_count=64 then exit;
  error_stk[error_count]:=n;
  inc(error_count);
end;

(* get last error from error stack *)
function jpeg_geterror:integer;
begin
 if error_count=0 then jpeg_geterror:=0
 else
   begin
   dec(error_count);
   jpeg_geterror:=error_stk[error_count];
   end;
end;

(* open file *)
function file_open (s:string):boolean;
begin
  assignfile (f,s);
  {$i-}
  reset(f,1);
  {$i+}
  if ioresult<>0 then error(2)
  else
    begin
    bsize:=filesize(f);
    getmem (data,bsize);
    blockread (f,data^,bsize);
    closefile(f);
    end;
  if error_count=0 then file_open:=true
                   else file_open:=false;
end;

(* free memory *)
procedure file_close;
begin
  if (data<>nil) then freemem (data,bsize);
end;

(* get byte *)
function get_byte:integer;
begin
  if bpos=bsize then feof:=true
  else
    begin
    get_byte:=data^[bpos];
    inc(bpos);
    end;
end;

(* get word *)
function get_word:integer;
begin
  get_word:=(get_byte shl 8)+get_byte
end;

(* get bit *)
function getbit:integer;
var bit:byte;
    x:byte;
begin
  if msk=0 then
    begin
    chr:=get_byte;
    if chr=255 then
      begin
      x:=get_byte; if (x<>0) then error(3);
      end;
    msk:=128;
    end;
  bit:=chr and msk;
  if bit<>0 then bit:=1;
  msk:=msk shr 1;
  getbit:=bit;
end;

(* decode word *)
function word_dec(n:integer):integer;
var w,s,i:integer;
begin
  if n=0 then word_dec:=0
  else
    begin
    w:=getbit; s:=w;
    for i:=1 to n-1 do w:=w+w+getbit;
    if s=0 then w:=(w or ($ffffffff shl n))+1;
    word_dec:=w;
    end;
end;

(* get image information *)
procedure get_info;
var cn,sf,qt:byte;
    i:integer;
begin
  prec:=get_byte; yres:=get_word; xres:=get_word;
  if prec<>8 then error(4);
  ncomp:=get_byte;
  if (ncomp<>3) and (ncomp<>1) then error(4);
  for i:=0 to ncomp-1 do
    begin
    cn:=get_byte; sf:=get_byte; qt:=get_byte;
    component[cn-1].qtab:=@qtable[qt];
    component[cn-1].smpy:=sf and 15;
    component[cn-1].smpx:=(sf shr 4)and 15;
    end;
  (* find block size depending on first component *)
  if component[0].smpx=1 then blockx:=8
                         else blockx:=16;

  if component[0].smpy=1 then blocky:=8
                         else blocky:=16;
  (* find number of blocks in image *)
  xblock:=xres div blockx; if xres and (blockx-1)<>0 then inc(xblock);
  yblock:=yres div blocky; if yres and (blocky-1)<>0 then inc(yblock);
end;


(*         decode huffman table from jpeg stream          *)
(* unpacks huffman length codes and creates huffman codes *)
procedure decode_hufftable(len:integer);
var lengths:array[0..15] of byte;
    b,a:byte;
    i,j,n,bit:integer;
    length:array[0..256] of word;
    symbol:array[0..256] of byte;
    code,codelen:word;
    position,free,delta:word;
    h:phuff;
begin
  dec(len,2);
  while len>0 do
    begin
    b:=get_byte;
    dec(len);
    case b of
      0  : h:=@hufftable_dc[0];
      1  : h:=@hufftable_dc[1];
      16 : h:=@hufftable_ac[0];
      17 : h:=@hufftable_ac[1];
    end;

    for i:=0 to 15 do lengths[i]:=get_byte;
    dec(len,16);
    n:=0;
    for i:=0 to 15 do
      begin
      dec(len,lengths[i]);
      for j:=0 to lengths[i]-1 do
        begin
        a:=get_byte; symbol[n]:=a; length[n]:=i+1; inc(n);
        end;
      end;

    for i:=0 to 256 do
      begin
      h[0][i]:=32760; h[1][i]:=32760;
      end;

    free:=2;
    code:=0; codelen:=length[0];
    for i:=0 to n-1 do
      begin
      position:=1;
      for j:=codelen-1 downto 1 do
        begin
        bit:=(code shr j) and 1;
        if h[bit][position]=32760 then
          begin
          h[bit][position]:=-free; inc(free);
          end;
        position:=-h[bit][position];
        end;
      h[code and 1][position]:=symbol[i];
      if i<n-1 then
        begin
        inc(code);
        delta:=length[i+1]-codelen;
        code:=code shl delta;
        inc(codelen,delta);
        end;
      end;
    end;
end;

(* decode symbol using huffman tree *)
function huff_dec(h:phuff):integer;
var ps:integer;
begin
  ps:=-1;
  while ps<0 do ps:=h[getbit,-ps];
  if ps=32760 then error(3);
  huff_dec:=ps;
end;

(* fast inverse discrete cosine transform *)
procedure idct;
const
  a:single=0.353553385;
  b:single=0.490392625;
  c:single=0.415734798;
  d:single=0.277785122;
  e:single=0.097545162;
  f:single=0.461939752;
  g:single=0.191341713;
  cd:single=0.6935199499;
  be:single=0.5879377723;
  bc:single=0.9061274529;
  de:single=0.3753302693;

var i:integer;
    a0,f2,g2,a4,f6,g6:single;
    s0,s1,s2,s3:single;
    t0,t1,t2,t3:single;
    m0,m1,m2,m3:single;
    h0,h1,h2,h3:single;
    r0,r1,r2,r3:single;
    w:single;
begin

i:=0;
while i<64 do
  begin
  if (dctt[i+1]<>0) or (dctt[i+2]<>0) or (dctt[i+3]<>0) or
     (dctt[i+4]<>0) or (dctt[i+5]<>0) or (dctt[i+6]<>0) or(dctt[i+7]<>0) then
  begin
  a0:=a*dctt[i];   f2:=f*dctt[i+2]; g2:=g*dctt[i+2];
  a4:=a*dctt[i+4]; g6:=g*dctt[i+6]; f6:=f*dctt[i+6];
  m0:=a0+a4;  m1:=a0-a4;  m2:=f2+g6;
  m3:=g2-f6;  s0:=m0+m2;  s1:=m1+m3;
  s2:=m1-m3;  s3:=m0-m2;
  h2:=dctt[i+7]+dctt[i+1]; h3:=dctt[i+7]-dctt[i+1];
  r2:=dctt[i+3]+dctt[i+5]; r3:=dctt[i+3]-dctt[i+5];
  h0:=cd*dctt[i+1]; h1:=be*dctt[i+1];
  r0:=be*dctt[i+5]; r1:=cd*dctt[i+3];
  w:=de*r3; t0:=h1+r1+e*(h3+r3)-w; t1:=h0-r0-d*(h2-r3)-w;
  w:=bc*r2; t2:=h0+r0+c*(h3+r2)-w; t3:=h1-r1-b*(h2+r2)+w;
  dctt[i+0]:=s0+t0; dctt[i+1]:=s1+t1;
  dctt[i+2]:=s2+t2; dctt[i+3]:=s3+t3;
  dctt[i+4]:=s3-t3; dctt[i+5]:=s2-t2;
  dctt[i+6]:=s1-t1; dctt[i+7]:=s0-t0;
  end
else
  begin
  a0:=dctt[i]*a;
  dctt[i]:=a0;   dctt[i+1]:=a0; dctt[i+2]:=a0; dctt[i+3]:=a0;
  dctt[i+4]:=a0; dctt[i+5]:=a0; dctt[i+6]:=a0; dctt[i+7]:=a0;
  end;
inc(i,8);
end;

for i:=0 to 7 do
  if (dctt[i+8]<>0)  or (dctt[i+16]<>0) or (dctt[i+24]<>0) or
     (dctt[i+32]<>0) or (dctt[i+40]<>0) or (dctt[i+48]<>0) or(dctt[i+56]<>0) then
  begin
  a0:=a*dctt[i];    f2:=f*dctt[i+16]; g2:=g*dctt[i+16];
  a4:=a*dctt[i+32]; g6:=g*dctt[i+48]; f6:=f*dctt[i+48];
  m0:=a0+a4;  m1:=a0-a4;  m2:=f2+g6;
  m3:=g2-f6;  s0:=m0+m2;  s1:=m1+m3;
  s2:=m1-m3;  s3:=m0-m2;
  h2:=dctt[i+56]+dctt[i+8];  h3:=dctt[i+56]-dctt[i+8];
  r2:=dctt[i+24]+dctt[i+40]; r3:=dctt[i+24]-dctt[i+40];
  h0:=cd*dctt[i+8];  h1:=be*dctt[i+8];
  r0:=be*dctt[i+40]; r1:=cd*dctt[i+24];
  w:=de*r3; t0:=h1+r1+e*(h3+r3)-w; t1:=h0-r0-d*(h2-r3)-w;
  w:=bc*r2; t2:=h0+r0+c*(h3+r2)-w; t3:=h1-r1-b*(h2+r2)+w;
  dctt[i]:=s0+t0;    dctt[i+8]:=s1+t1;
  dctt[i+16]:=s2+t2; dctt[i+24]:=s3+t3;
  dctt[i+32]:=s3-t3; dctt[i+40]:=s2-t2;
  dctt[i+48]:=s1-t1; dctt[i+56]:=s0-t0;
  end
else
  begin
  a0:=dctt[i]*a;
  dctt[i]:=a0;    dctt[i+8]:=a0;  dctt[i+16]:=a0; dctt[i+24]:=a0;
  dctt[i+32]:=a0; dctt[i+40]:=a0; dctt[i+48]:=a0; dctt[i+56]:=a0;
  end;
end;


(* decode quantization table from file (full support) *)
procedure decode_qtable(len:integer);
var i:integer;
    b:byte;
begin
  dec(len,2);
  while len>0 do
    begin
    b:=get_byte;
    dec(len);
    if b and 16=0 then
      begin
      for i:=0 to 63 do qtable[b and 15][i]:=get_byte;
      dec(len,64);
      end
    else
      begin
      for i:=0 to 63 do qtable[b and 15][i]:=get_word;
      dec(len,128);
      end;
    end;
end;


(* decode block of image *)
procedure decode_block;
var compn,i,j,a,b:integer;
    codelen:integer;
    code:integer;
    cx,cy:integer;
    otab:array[0..63] of integer;
begin
(* for each component *)
for compn:=0 to ncomp-1 do
  begin
  (* depending on sampling decode one or more 8x8 blocks *)
  for cy:=0 to component[compn].smpy-1 do
    for cx:=0 to component[compn].smpx-1 do
      begin
      for i:=0 to 63 do otab[i]:=0;
      codelen:=huff_dec(component[compn].huff_dc); if error_count<>0 then exit;
      code:=word_dec(codelen); if error_count<>0 then exit;
      otab[0]:=code+component[compn].dc_prev;
      component[compn].dc_prev:=otab[0];
      i:=1;
      while i<64 do
        begin
        codelen:=huff_dec(component[compn].huff_ac); if error_count<>0 then exit;
        if codelen=$0 then i:=64
        else
        if codelen=$f0 then i:=i+16
        else
          begin
          code:=word_dec(codelen and 15); if error_count<>0 then exit;
          i:=i+(codelen shr 4); otab[i]:=code; inc(i);
          end;
        end;

    (* dequantize and dezigzag data *)
    for i:=0 to 63 do
      dctt[zig[i]]:=component[compn].qtab[i]*otab[i];

    (* calculate inverse cosine transform *)
    idct;

    (* put data in components output matrix *)
      b:=(cy shl 7)+(cx shl 3); a:=0;
      for i:=0 to 7 do
        begin
        for j:=0 to 7 do
          begin
	  component[compn].t[b]:=dctt[a]+128;
          inc(b); inc(a);
          end;
        inc(b,8);
        end;
    end;
   end;
end;

(* decode scan data (whole image) *)
procedure decode_scan(p:pjpeg);
var nnx,nny,i,j,k:integer;
    cr,cg,cb:integer;
    cy,cu,cv:single;
    ncomp:byte;
    sc,ts:byte;
    xmin,ymin,xmax,ymax:integer;
    blockn,intn:integer;
    y1,u1,v1,y2,u2,v2,u3,v3:integer;
    dux,duy,dvx,dvy:integer;
    adr1,adr2:integer;
begin
  (* fill information fields *)
  p^.xres:=xres; p^.yres:=yres;

  (* decode huffman table selectors for components *)
  ncomp:=get_byte;
  for i:=0 to ncomp-1 do
    begin
    sc:=get_byte; ts:=get_byte;
    component[sc-1].huff_dc:=@hufftable_dc[ts shr 4];
    component[sc-1].huff_ac:=@hufftable_ac[ts and 15];
    end;

  ss_start:=get_byte;
  ss_end:=get_byte;
  sbits:=get_byte;
  if (ss_start<>0) or (ss_end<>63) then
    begin
    error(4);
    end;

  msk:=0;
  (* precalculate scalling *)
  if (ncomp=3) then
    begin
    dux:=2+component[1].smpx-component[0].smpx;
    duy:=2+component[1].smpy-component[0].smpy;
    dvx:=2+component[2].smpx-component[0].smpx;
    dvy:=2+component[2].smpy-component[0].smpy;
    end;

  (* render output color block *)
  blockn:=0; intn:=0;
  ymin:=0;
  for nny:=0 to yblock-1 do
    begin
    ymax:=ymin+blocky; if ymax>yres then ymax:=yres;
    xmin:=0;
    for nnx:=0 to xblock-1 do
      begin
      xmax:=xmin+blockx; if xmax>xres then xmax:=xres;
      decode_block; inc(blockn);
      if (blockn=restart_int) and ((nnx<xblock-1) or (nny<yblock-1)) then
        begin
        if get_byte<>$ff then error(3);
        if get_byte<>(intn and 7)+$d0 then error(3);
        msk:=0; inc(intn); blockn:=0;
        for i:=0 to ncomp-1 do component[i].dc_prev:=0;
        end;

      if ncomp=3 then
        begin
        y1:=0; u1:=0; v1:=0;
        adr1:=ymin*xres+xmin;
        for i:=ymin to ymax-1 do
          begin
          adr2:=adr1; inc(adr1,xres);
          y2:=y1; y1:=y1+16;
          u3:=(u1 shr 1) shl 4; u1:=u1+duy;
          v3:=(v1 shr 1) shl 4; v1:=v1+dvy;
          u2:=0;  v2:=0;
          for j:=xmin to xmax-1 do
            begin
            cy:=component[0].t[y2];
            cu:=component[1].t[u3+u2 shr 1]-128;
            cv:=component[2].t[v3+v2 shr 1]-128;

            cr:=round (cy+1.402*cv);
            cg:=round (cy-0.34414*cu-0.71414*cv);
            cb:=round (cy+1.772*cu);
            if cr<0 then cr:=0; if cr>255 then cr:=255;
            if cg<0 then cg:=0; if cg>255 then cg:=255;
            if cb<0 then cb:=0; if cb>255 then cb:=255;
            p^.image[adr2]:=cr+cg shl 8 +cb shl 16;
            inc(y2,1); inc(u2,dux); inc(v2,dvx); inc(adr2);
            end;
          end;
        end
      else if ncomp=1 then
        begin
        y1:=0;
        adr1:=ymin*xres+xmin;
        for i:=ymin to ymax-1 do
          begin
          adr2:=adr1; inc(adr1,xres);
          y2:=y1; y1:=y1+16;
          for j:=xmin to xmax-1 do
            begin
            cr:=round(component[0].t[y2]);
            if cr<0 then cr:=0; if cr>255 then cr:=255;
            p^.image[adr2]:=cr+cr shl 8 +cr shl 16;
            inc(y2); inc(adr2);
            end;
          end;
        end;
      xmin:=xmax;
      end;
    ymin:=ymax;
    end;
end;

procedure end_of_image;
begin
end;

(* delete decoded image *)
procedure jpeg_delete (p:pjpeg);
begin
  freemem (p,(p^.xres*p^.yres+2)*4);
end;

(* decode image from data in memory *)
function decode_image:pjpeg;
var p:pjpeg;
    a:byte;
    w:integer;
    hdr,scan:boolean;
    cpos:longint;
begin
    p:=nil;
    bpos:=0; feof:=false;
    w:=get_word;
    if w<>$ffd8 then error(3);
    hdr:=false; scan:=false;
    while not feof and (error_count=0) do
      begin
      a:=get_byte;   if a<>255 then halt;
      a:=get_byte;
      w:=get_word;
      case a of
          $e0 : begin
                if not hdr then
                  begin
                  if get_byte<>ord('J') then error(1);
                  if get_byte<>ord('F') then error(1);
                  if get_byte<>ord('I') then error(1);
                  if get_byte<>ord('F') then error(1);
                  hdr:=true;
                  w:=w-4;
                  end;
                end;
          $c0 : begin
                get_info;
                w:=0;
                end;
          $c1 : begin
                end;
          $c4 : begin
                decode_hufftable(w);
                w:=0;
                end;
          $d8 : begin
                end;
          $d9 : begin
                end_of_image;
                w:=0;
                end;
          $da : begin
                  if not scan then
                    begin
                    scan:=true;
                    getmem(p,xres*yres*4+2*4);
                    decode_scan(p);
                    if error_count<>0 then
                      begin
                      freemem(p,xres*yres*4+2*4);
                      p:=nil;
                      end;
                    w:=0;
                    end;
                end;
          $db : begin
                decode_qtable(w);
                w:=0;
                end;
          $dd : begin
                restart_int:=get_word;
                w:=0;
                end;
        end;
        while w>2 do
          begin
          get_byte;
          dec(w);
          end;
    end;
  decode_image:=p;
end;


(* decode image from given memory pointer*)
function jpeg_decode (q:pbyte;n:integer):pjpeg;
begin
  data:=q;
  jpeg_init;
  bsize:=n;
  restart_int:=-1;
  jpeg_decode:=decode_image;
end;

(* decode jpeg from file *)
function jpeg_load (fn:string):pjpeg;
var f:textfile;
    i:integer;
begin
  assignfile (f,'zig.txt');
  rewrite(f);
  for i:=0 to 63 do
    write (f,((zig[i] and 7) shl 3) or (zig[i] shr 3),',');
  close(f);

  jpeg_init;
  restart_int:=-1;
  filemode:=0;
  if file_open(fn) then jpeg_load:=decode_image
                   else jpeg_load:=nil;
  file_close;
end;

end.

